/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.ui.changes.ChangeManager;
import org.eclipse.n4js.ui.changes.IChange;
import org.eclipse.n4js.ui.quickfix.N4Modification;
import org.eclipse.n4js.ui.quickfix.N4ModificationWrapper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.quickfix.MarkerResolutionGenerator;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.Issue;

public class N4JSMarkerResolutionGenerator
extends MarkerResolutionGenerator {
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private ChangeManager changeManager;
    @Inject
    private IssueModificationContext.Factory modificationContextFactory;
    @Inject
    private IssueResolutionProvider resolutionProvider;
    @Inject(optional=true)
    private IWorkbench workbench;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (this.existsDirtyEditorFor(marker)) {
            this.showError_UnsavedChanges();
            return new IMarkerResolution[0];
        }
        if (marker.getResource() instanceof IProject) {
            Issue issue = this.getIssueUtil().createIssue(marker);
            List result = this.resolutionProvider.getResolutions(issue);
            return this.getAdaptedResolutions(Lists.newArrayList((Iterable)result));
        }
        return super.getResolutions(marker);
    }

    protected IMarkerResolution[] getAdaptedResolutions(List<IssueResolution> resolutions) {
        ArrayList<IssueResolution> validResolutions = new ArrayList<IssueResolution>(resolutions.size());
        if (this.isMultiApplyAttempt()) {
            for (IssueResolution currResolution : resolutions) {
                if (!this.supportsMultiApply(currResolution)) continue;
                validResolutions.add(currResolution);
            }
            if (validResolutions.size() < resolutions.size()) {
                this.showError_MultiApplyNotSupported();
            }
        } else {
            validResolutions.addAll(resolutions);
        }
        IMarkerResolution[] result = new IMarkerResolution[validResolutions.size()];
        int i = 0;
        while (i < validResolutions.size()) {
            result[i] = new MultiResolutionAdapter((IssueResolution)validResolutions.get(i));
            ++i;
        }
        return result;
    }

    private boolean isMarkerStillValid(IMarker marker) {
        if (marker == null) {
            return false;
        }
        if (marker.getResource() instanceof IProject) {
            return true;
        }
        XtextEditor editor = this.getEditor(marker.getResource());
        if (editor == null) {
            return false;
        }
        IAnnotationModel annotationModel = editor.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (annotationModel == null) {
            return false;
        }
        return this.isMarkerStillValid(marker, annotationModel);
    }

    private EObject getElementForMarker(IModificationContext context, IMarker marker) {
        try {
            return (EObject)context.getXtextDocument().readOnly(resource -> resource.getEObject(this.issueUtil.getUriToProblem(marker).fragment()));
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean supportsMultiApply(IssueResolution resolution) {
        return resolution.getModification() instanceof N4ModificationWrapper && ((N4ModificationWrapper)resolution.getModification()).getN4Modification() != null && ((N4ModificationWrapper)resolution.getModification()).getN4Modification().supportsMultiApply();
    }

    private boolean existsDirtyEditorFor(IMarker marker) {
        return this.existsDirtyEditorFor(new IMarker[]{marker});
    }

    private boolean existsDirtyEditorFor(IMarker[] markers) {
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            XtextEditor editorForMarker = this.findEditor(marker.getResource());
            if (editorForMarker != null && editorForMarker.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isMultiApplyAttempt() {
        if (this.workbench == null) {
            return false;
        }
        try {
            ISelectionService service = this.workbench.getActiveWorkbenchWindow().getSelectionService();
            IStructuredSelection sel = (IStructuredSelection)service.getSelection("org.eclipse.ui.views.ProblemView");
            return sel != null && sel.size() >= 2;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void showError_UnsavedChanges() {
        if (this.workbench == null) {
            return;
        }
        MessageDialog.openInformation((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)"Unsaved Changes", (String)"You have unsaved changes in one or more N4JS editors. Please save all changes before initiating a quick fix via the Problems view.");
    }

    private void showError_MultiApplyNotSupported() {
        if (this.workbench == null) {
            return;
        }
        MessageDialog.openInformation((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)"Cannot Apply To Multiple Issues", (String)"Some quick fixes are hidden because they do not support being applied to multiple issues at once.");
    }

    private class MultiResolutionAdapter
    extends WorkbenchMarkerResolution {
        private final Issue issue;
        private final IssueResolution resolution;

        private MultiResolutionAdapter(IssueResolution resolution) {
            if (!(resolution.getModificationContext() instanceof IssueModificationContext)) {
                throw new IllegalArgumentException("the resolution's modification context must be an IssueModificationContext");
            }
            this.issue = ((IssueModificationContext)resolution.getModificationContext()).getIssue();
            this.resolution = resolution;
        }

        public String getLabel() {
            return this.resolution.getLabel();
        }

        public Image getImage() {
            return N4JSMarkerResolutionGenerator.this.getImage(this.resolution);
        }

        public String getDescription() {
            return this.resolution.getDescription();
        }

        private boolean isBasedOnN4Modification() {
            return this.getN4Modification() != null;
        }

        private N4Modification getN4Modification() {
            if (this.resolution.getModification() instanceof N4ModificationWrapper) {
                return ((N4ModificationWrapper)this.resolution.getModification()).getN4Modification();
            }
            return null;
        }

        public void run(IMarker[] markers, IProgressMonitor monitor) {
            if (this.isBasedOnN4Modification()) {
                try {
                    ArrayList<? extends IChange> changes = new ArrayList<IChange>();
                    IMarker[] iMarkerArray = markers;
                    int n = markers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMarker currMarker = iMarkerArray[n2];
                        if (N4JSMarkerResolutionGenerator.this.isMarkerStillValid(currMarker)) {
                            Issue currIssue = N4JSMarkerResolutionGenerator.this.issueUtil.createIssue(currMarker);
                            IModificationContext currContext = N4JSMarkerResolutionGenerator.this.modificationContextFactory.createModificationContext(currIssue);
                            int offset = MarkerUtilities.getCharStart((IMarker)currMarker);
                            int length = MarkerUtilities.getCharEnd((IMarker)currMarker) - offset;
                            EObject element = N4JSMarkerResolutionGenerator.this.getElementForMarker(currContext, currMarker);
                            Collection<? extends IChange> changeSet = null;
                            changeSet = markers.length == 1 ? this.getN4Modification().computeChanges(currContext, currMarker, offset, length, element) : this.getN4Modification().computeOneOfMultipleChanges(currContext, currMarker, offset, length, element);
                            changes.addAll(changeSet);
                        }
                        ++n2;
                    }
                    this.getN4Modification().computeFinalChanges();
                    N4JSMarkerResolutionGenerator.this.changeManager.applyAll(changes);
                }
                catch (Exception e) {
                    throw new WrappedException("exception while applying resolution for quick fix '" + this.resolution.getLabel() + "'", e);
                }
            } else {
                if (markers.length != 1) {
                    throw new IllegalStateException();
                }
                this.resolution.apply();
            }
        }

        public void run(IMarker marker) {
            this.run(new IMarker[]{marker}, null);
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            if (N4JSMarkerResolutionGenerator.this.existsDirtyEditorFor(markers)) {
                N4JSMarkerResolutionGenerator.this.showError_UnsavedChanges();
                return new IMarker[0];
            }
            N4Modification n4modification = this.getN4Modification();
            if (n4modification == null || !n4modification.supportsMultiApply()) {
                return new IMarker[0];
            }
            ArrayList<IMarker> result = new ArrayList<IMarker>();
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker currMarker = iMarkerArray[n2];
                if (!this.isSameProblem(currMarker) && this.hasSameIssueCode(currMarker) && n4modification.isApplicableTo(currMarker)) {
                    result.add(currMarker);
                }
                ++n2;
            }
            return result.toArray(new IMarker[result.size()]);
        }

        private boolean hasSameIssueCode(IMarker marker) {
            String myCode = this.issue.getCode();
            return myCode != null && myCode.equals(N4JSMarkerResolutionGenerator.this.issueUtil.getCode(marker));
        }

        private boolean isSameProblem(IMarker marker) {
            URI myUriToProblem = this.issue.getUriToProblem();
            String code = N4JSMarkerResolutionGenerator.this.issueUtil.getCode(marker);
            if (code != null && code.equals("NON_EXISTING_PROJECT")) {
                myUriToProblem = myUriToProblem.appendFragment(Integer.toString(marker.hashCode()));
            }
            return myUriToProblem != null && myUriToProblem.equals(N4JSMarkerResolutionGenerator.this.issueUtil.getUriToProblem(marker));
        }
    }
}

