/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

class TypeCompareLogic {
    TypeCompareLogic() {
    }

    static <T extends Type> int compareTypes(IQualifiedNameProvider fqnProvider, Iterable<T> tvs1, Iterable<T> tvs2) {
        Iterator<T> iter1 = tvs1.iterator();
        Iterator<T> iter2 = tvs2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            int c = TypeCompareLogic.compare(fqnProvider, (Type)iter1.next(), (Type)iter2.next());
            if (c == 0) continue;
            return c;
        }
        if (iter1.hasNext()) {
            return 1;
        }
        if (iter2.hasNext()) {
            return -1;
        }
        return 0;
    }

    static <T extends TypeArgument> int compareTypeArguments(IQualifiedNameProvider fqnProvider, Iterable<T> tvs1, Iterable<T> tvs2) {
        Iterator<T> iter1 = tvs1.iterator();
        Iterator<T> iter2 = tvs2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            int c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)iter1.next(), (TypeArgument)iter2.next());
            if (c == 0) continue;
            return c;
        }
        if (iter1.hasNext()) {
            return 1;
        }
        if (iter2.hasNext()) {
            return -1;
        }
        return 0;
    }

    static int compare(IQualifiedNameProvider fqnProvider, Type t1, Type t2) {
        if (t1 == t2) {
            return 0;
        }
        if (t1 == null) {
            return -1;
        }
        if (t2 == null) {
            return 1;
        }
        if (t1.getVersion() != t2.getVersion()) {
            return 1;
        }
        if (fqnProvider != null) {
            QualifiedName name1 = fqnProvider.getFullyQualifiedName((EObject)t1);
            QualifiedName name2 = fqnProvider.getFullyQualifiedName((EObject)t2);
            if (name1 == null && name2 == null) {
                return 1;
            }
            if (name1 == null) {
                return -1;
            }
            if (name2 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
        return 1;
    }

    static int compare(IQualifiedNameProvider fqnProvider, TypeArgument arg1, TypeArgument arg2) {
        ComposedTypeRef cref2;
        ComposedTypeRef cref1;
        if (arg1 == arg2) {
            return 0;
        }
        if (arg1 == null) {
            return -1;
        }
        if (arg2 == null) {
            return 1;
        }
        if (arg1 instanceof Wildcard || arg2 instanceof Wildcard) {
            if (arg1 instanceof Wildcard && arg2 instanceof Wildcard) {
                Wildcard w1 = (Wildcard)arg1;
                Wildcard w2 = (Wildcard)arg2;
                int c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)w1.getDeclaredLowerBound(), (TypeArgument)w2.getDeclaredLowerBound());
                if (c != 0) {
                    return c;
                }
                c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)w1.getDeclaredUpperBound(), (TypeArgument)w2.getDeclaredUpperBound());
                if (c != 0) {
                    return c;
                }
                return 0;
            }
            return TypeCompareLogic.compareEClasses(arg1.eClass(), arg2.eClass());
        }
        TypeRef ref1 = (TypeRef)arg1;
        TypeRef ref2 = (TypeRef)arg2;
        if (ref1 instanceof FunctionTypeExprOrRef && ref2 instanceof FunctionTypeExprOrRef) {
            FunctionTypeExprOrRef f1 = (FunctionTypeExprOrRef)ref1;
            FunctionTypeExprOrRef f2 = (FunctionTypeExprOrRef)ref2;
            return TypeCompareLogic.compareFunctionTypeExprOrRefs(fqnProvider, f1, f2);
        }
        int c = TypeCompareLogic.compareEClasses(ref1.eClass(), ref2.eClass());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compare(fqnProvider, ref1.getDeclaredType(), ref2.getDeclaredType());
        if (c != 0) {
            return c;
        }
        if (ref1 instanceof StructuralTypeRef) {
            StructuralTypeRef sref1 = (StructuralTypeRef)ref1;
            StructuralTypeRef sref2 = (StructuralTypeRef)ref2;
            c = TypeCompareLogic.compareComparables(sref1.getTypingStrategy(), sref2.getTypingStrategy());
            if (c != 0) {
                return c;
            }
            c = TypeCompareLogic.compare(fqnProvider, (Type)sref1.getStructuralType(), (Type)sref2.getStructuralType());
            if (c != 0) {
                return c;
            }
            Iterator iter1 = sref1.getStructuralMembers().iterator();
            Iterator iter2 = sref2.getStructuralMembers().iterator();
            while (iter1.hasNext() && iter2.hasNext()) {
                c = TypeCompareLogic.compareMembers(fqnProvider, (TStructMember)iter1.next(), (TStructMember)iter2.next());
                if (c == 0) continue;
                return c;
            }
            if (iter1.hasNext()) {
                return 1;
            }
            if (iter2.hasNext()) {
                return -1;
            }
        }
        if (ref1 instanceof ParameterizedTypeRef) {
            ParameterizedTypeRef pref1 = (ParameterizedTypeRef)ref1;
            ParameterizedTypeRef pref2 = (ParameterizedTypeRef)ref2;
            c = TypeCompareLogic.compareTypeArguments(fqnProvider, pref1.getTypeArgs(), pref2.getTypeArgs());
            if (c != 0) {
                return c;
            }
        } else if (ref1 instanceof ComposedTypeRef) {
            cref1 = (ComposedTypeRef)ref1;
            cref2 = (ComposedTypeRef)ref2;
            c = TypeCompareLogic.compareTypeArguments(fqnProvider, cref1.getTypeRefs(), cref2.getTypeRefs());
            if (c != 0) {
                return c;
            }
        } else if (ref1 instanceof TypeTypeRef) {
            cref1 = (TypeTypeRef)ref1;
            cref2 = (TypeTypeRef)ref2;
            c = TypeCompareLogic.compareComparables(cref1.isConstructorRef(), cref2.isConstructorRef());
            if (c != 0) {
                return c;
            }
            c = TypeCompareLogic.compare(fqnProvider, cref1.getTypeArg(), cref2.getTypeArg());
            if (c != 0) {
                return c;
            }
        } else if (ref1 instanceof BoundThisTypeRef) {
            BoundThisTypeRef bref1 = (BoundThisTypeRef)ref1;
            BoundThisTypeRef bref2 = (BoundThisTypeRef)ref2;
            c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)bref1.getActualThisTypeRef(), (TypeArgument)bref2.getActualThisTypeRef());
            if (c != 0) {
                return c;
            }
        } else if (ref1 instanceof ExistentialTypeRef) {
            ExistentialTypeRef e1 = (ExistentialTypeRef)ref1;
            ExistentialTypeRef e2 = (ExistentialTypeRef)ref2;
            boolean reopened1 = e1.isReopened();
            boolean reopened2 = e2.isReopened();
            c = TypeCompareLogic.compareComparables(reopened1, reopened2);
            if (c != 0) {
                return c;
            }
            if (reopened1 && reopened2) {
                return TypeCompareLogic.compare(fqnProvider, (TypeArgument)e1.getWildcard(), (TypeArgument)e2.getWildcard());
            }
            return TypeCompareLogic.compareComparables(e1.getId(), e2.getId());
        }
        if ((c = Boolean.compare(ref1.isDynamic(), ref2.isDynamic())) != 0) {
            return c;
        }
        return 0;
    }

    private static int compareFunctionTypeExprOrRefs(IQualifiedNameProvider fqnProvider, FunctionTypeExprOrRef f1, FunctionTypeExprOrRef f2) {
        if (f1 == f2) {
            return 0;
        }
        if (f1 == null) {
            return -1;
        }
        if (f2 == null) {
            return 1;
        }
        int c = TypeCompareLogic.compareComparables(TypeCompareLogic.getFunctionName(f1), TypeCompareLogic.getFunctionName(f2));
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)f1.getDeclaredThisType(), (TypeArgument)f2.getDeclaredThisType());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compareTypes(fqnProvider, f1.getTypeVars(), f2.getTypeVars());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)f1.getReturnTypeRef(), (TypeArgument)f2.getReturnTypeRef());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compareFormalParameters(fqnProvider, (Iterable<TFormalParameter>)f1.getFpars(), (Iterable<TFormalParameter>)f2.getFpars());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    private static int compareMembers(IQualifiedNameProvider fqnProvider, TStructMember m1, TStructMember m2) {
        if (m1 == m2) {
            return 0;
        }
        if (m1 == null) {
            return -1;
        }
        if (m2 == null) {
            return 1;
        }
        int c = TypeCompareLogic.compareEClasses(m1.eClass(), m2.eClass());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compareComparables(m1.getMemberAccessModifier(), m2.getMemberAccessModifier());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compareComparables(m1.getName(), m2.getName());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)TypeCompareLogic.getMemberTypeRef(m1), (TypeArgument)TypeCompareLogic.getMemberTypeRef(m2));
        if (c != 0) {
            return c;
        }
        if (m1 instanceof TStructMethod) {
            TStructMethod method1 = (TStructMethod)m1;
            TStructMethod method2 = (TStructMethod)m2;
            c = TypeCompareLogic.compareFormalParameters(fqnProvider, (Iterable<TFormalParameter>)method1.getFpars(), (Iterable<TFormalParameter>)method2.getFpars());
            if (c != 0) {
                return c;
            }
        }
        return 0;
    }

    private static int compareFormalParameters(IQualifiedNameProvider fqnProvider, Iterable<TFormalParameter> fpars1, Iterable<TFormalParameter> fpars2) {
        Iterator<TFormalParameter> iter1 = fpars1.iterator();
        Iterator<TFormalParameter> iter2 = fpars2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            int c = TypeCompareLogic.compareFormalParameters(fqnProvider, iter1.next(), iter2.next());
            if (c == 0) continue;
            return c;
        }
        if (iter1.hasNext()) {
            return 1;
        }
        if (iter2.hasNext()) {
            return -1;
        }
        return 0;
    }

    private static int compareFormalParameters(IQualifiedNameProvider fqnProvider, TFormalParameter p1, TFormalParameter p2) {
        if (p1 == p2) {
            return 0;
        }
        if (p1 == null) {
            return -1;
        }
        if (p2 == null) {
            return 1;
        }
        int c = TypeCompareLogic.compareComparables(p1.getName(), p2.getName());
        if (c != 0) {
            return c;
        }
        c = TypeCompareLogic.compare(fqnProvider, (TypeArgument)p1.getTypeRef(), (TypeArgument)p2.getTypeRef());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(p1.isOptional(), p2.isOptional());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(p1.isVariadic(), p2.isVariadic());
        if (c != 0) {
            return c;
        }
        return 0;
    }

    private static int compareEClasses(EClass ec1, EClass ec2) {
        if (ec1 == ec2) {
            return 0;
        }
        if (ec1 == null) {
            return -1;
        }
        if (ec2 == null) {
            return 1;
        }
        if (ec1.getEPackage() == ec2.getEPackage()) {
            return ec1.getClassifierID() - ec2.getClassifierID();
        }
        return ec1.getEPackage().getNsURI().compareTo(ec2.getEPackage().getNsURI());
    }

    private static <T extends Comparable<T>> int compareComparables(T c1, T c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        return c1.compareTo(c2);
    }

    private static String getFunctionName(FunctionTypeExprOrRef f) {
        TFunction ft = f.getFunctionType();
        return ft != null ? ft.getName() : null;
    }

    private static TypeRef getMemberTypeRef(TStructMember m) {
        if (m instanceof TStructField) {
            return ((TStructField)m).getTypeRef();
        }
        if (m instanceof TStructGetter) {
            return ((TStructGetter)m).getDeclaredTypeRef();
        }
        if (m instanceof TStructSetter) {
            return ((TStructSetter)m).getDeclaredTypeRef();
        }
        if (m instanceof TStructMethod) {
            return ((TStructMethod)m).getReturnTypeRef();
        }
        return null;
    }
}

