/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.n4js.smith.CollectedDataAccess;
import org.eclipse.n4js.smith.DataSeries;
import org.eclipse.n4js.smith.SimpleTimeFormat;
import org.eclipse.n4js.smith.ui.graph.StackNode;
import org.eclipse.n4js.smith.ui.graph.VisualisationGraph;
import org.eclipse.n4js.smith.ui.graph.VisualisationNode;
import org.eclipse.n4js.smith.ui.graph.VisualisationSnapshot;
import org.eclipse.n4js.utils.IndentLevel;

public class StackGraphFactory {
    public static VisualisationSnapshot buildGraph(String key, float baseHeight, float baseWidth, String label) {
        DataSeries dataSeries = CollectedDataAccess.getDataSeries((String)key);
        if (dataSeries.hasNoData()) {
            return new VisualisationSnapshot(label, new VisualisationGraph(new VisualisationNode[0]), String.valueOf(label) + " (no data)");
        }
        return StackGraphFactory.createStackGraph(dataSeries, baseHeight, baseWidth, label);
    }

    private static VisualisationSnapshot createStackGraph(DataSeries series, float baseHeight, float baseWidth, String label) {
        StringJoiner sj = new StringJoiner("\n");
        IndentLevel indent = new IndentLevel("\t");
        sj.add(String.valueOf(indent.get()) + SimpleTimeFormat.convert((long)series.sum) + " - " + series.name);
        StackNode root = new StackNode(series.name, String.valueOf(series.name) + " took " + SimpleTimeFormat.convert((long)series.sum), baseWidth, baseHeight, 1.0f, 1.0f);
        StackGraphFactory.collectData(series, root, baseHeight, baseWidth, sj, indent);
        return new VisualisationSnapshot(label, new VisualisationGraph(root), sj.toString());
    }

    private static void collectData(DataSeries parentSeries, StackNode parentNode, float baseHeight, float baseWidth, StringJoiner sj, IndentLevel indent) {
        if (parentSeries.hasNoChildren()) {
            return;
        }
        indent.increase();
        Long siblingSum = parentSeries.getChildren().map(s -> s.sum).max(Long::compare).get();
        List siblings = parentSeries.getChildren().collect(Collectors.toList());
        Collections.sort(siblings, (s1, s2) -> Long.compare(s2.sum, s1.sum));
        long total = 0L;
        for (DataSeries series : siblings) {
            sj.add(String.valueOf(indent.get()) + SimpleTimeFormat.convert((long)series.sum) + " - " + series.name);
            float parentScale = (float)series.sum.longValue() / (float)parentSeries.sum.longValue();
            float siblingScale = (float)series.sum.longValue() / (float)siblingSum.longValue();
            StackNode node = new StackNode(series.name, String.valueOf(series.name) + " took " + SimpleTimeFormat.convert((long)series.sum), parentNode.width * parentScale, baseHeight, parentScale, siblingScale);
            parentNode.addChild(node);
            StackGraphFactory.collectData(series, node, baseHeight, baseWidth, sj, indent);
            total += series.sum.longValue();
        }
        long missing = parentSeries.sum - total;
        sj.add(String.valueOf(indent.get()) + "NOT INCLUDED: " + SimpleTimeFormat.convert((long)missing));
        indent.decrease();
    }
}

