/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ide.xtext.server.build.XBuildRequest;
import org.eclipse.xtext.generator.IContextualOutputConfigurationProvider;
import org.eclipse.xtext.generator.IFilePostProcessor;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.URIBasedFileSystemAccess;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IProjectConfigProvider;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class XURIBasedFileSystemAccessFactory {
    @Inject
    private IContextualOutputConfigurationProvider outputConfigurationProvider;
    @Inject
    private IFilePostProcessor postProcessor;
    @Inject(optional=true)
    private IEncodingProvider encodingProvider;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject(optional=true)
    private IProjectConfigProvider projectConfigProvider;

    public URIBasedFileSystemAccess newFileSystemAccess(Resource resource, XBuildRequest request) {
        ISourceFolder sourceFolder;
        IProjectConfig projectConfig;
        URIBasedFileSystemAccess uriBasedFileSystemAccess = new URIBasedFileSystemAccess();
        uriBasedFileSystemAccess.setOutputConfigurations(IterableExtensions.toMap((Iterable)this.outputConfigurationProvider.getOutputConfigurations(resource), OutputConfiguration::getName));
        uriBasedFileSystemAccess.setPostProcessor(this.postProcessor);
        if (this.encodingProvider != null) {
            uriBasedFileSystemAccess.setEncodingProvider(this.encodingProvider);
        }
        uriBasedFileSystemAccess.setTraceFileNameProvider(this.traceFileNameProvider);
        uriBasedFileSystemAccess.setTraceRegionSerializer(this.traceRegionSerializer);
        uriBasedFileSystemAccess.setGenerateTraces(true);
        uriBasedFileSystemAccess.setBaseDir(request.getBaseDir());
        if (this.projectConfigProvider != null && (projectConfig = this.projectConfigProvider.getProjectConfig(resource.getResourceSet())) != null && (sourceFolder = projectConfig.findSourceFolderContaining(resource.getURI())) != null) {
            uriBasedFileSystemAccess.setCurrentSource(sourceFolder.getName());
        }
        uriBasedFileSystemAccess.setConverter(resource.getResourceSet().getURIConverter());
        return uriBasedFileSystemAccess;
    }
}

