/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor.autoedit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.impl.VoidTypeImpl;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.ui.editor.N4JSDocument;
import org.eclipse.n4js.ui.organize.imports.XtextResourceUtils;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.ui.editor.autoedit.CommandInfo;
import org.eclipse.xtext.ui.editor.autoedit.MultiLineTerminalsEditStrategy;

public class JSDocEditStrategy
extends MultiLineTerminalsEditStrategy {
    private static final String OPENING_STR = "/**";
    private static final String INDENTATION_STR = " * ";
    private static final String CLOSING_STR = " */";
    private static final String PARAM_STR = "@param ";
    private static final String RETURN_STR = "@return ";

    public JSDocEditStrategy() {
        super(OPENING_STR, INDENTATION_STR, CLOSING_STR, false);
    }

    protected CommandInfo handleCursorInFirstLine(IDocument document, DocumentCommand command, IRegion startTerminal, IRegion stopTerminal) throws BadLocationException {
        CommandInfo newC = new CommandInfo();
        List<String> returnTypeAndParameterNames = this.getReturnTypeAndParameterNames(document, startTerminal);
        String paramString = "";
        String returnString = "";
        if (returnTypeAndParameterNames.size() > 0 && returnTypeAndParameterNames.get(0).equals("return")) {
            returnString = " * @return " + command.text;
        }
        if (returnTypeAndParameterNames.size() > 1) {
            int i = 1;
            while (i < returnTypeAndParameterNames.size()) {
                paramString = String.valueOf(paramString) + command.text + INDENTATION_STR + PARAM_STR + returnTypeAndParameterNames.get(i);
                ++i;
            }
        }
        newC.isChange = true;
        newC.offset = command.offset;
        newC.text = String.valueOf(newC.text) + command.text + INDENTATION_STR;
        newC.cursorOffset = command.offset + newC.text.length();
        if (stopTerminal == null && this.atEndOfLineInput(document, command.offset)) {
            newC.text = String.valueOf(newC.text) + command.text + this.getRightTerminal();
        }
        if (stopTerminal != null && stopTerminal.getOffset() >= command.offset && this.util.isSameLine(document, stopTerminal.getOffset(), command.offset)) {
            String string = document.get(command.offset, stopTerminal.getOffset() - command.offset);
            if (string.trim().length() > 0) {
                newC.text = String.valueOf(newC.text) + string.trim();
            }
            newC.text = returnTypeAndParameterNames.size() != 0 ? String.valueOf(newC.text) + paramString + command.text + returnString : String.valueOf(newC.text) + command.text;
            newC.length += string.length();
        }
        return newC;
    }

    private List<String> getReturnTypeAndParameterNames(IDocument document, IRegion startTerminal) {
        List retAndfparNames = null;
        if (document instanceof N4JSDocument) {
            retAndfparNames = (List)((N4JSDocument)document).tryReadOnly(xtextResource -> {
                Script script = XtextResourceUtils.getScript(xtextResource);
                ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)NodeModelUtils.findActualNodeFor((EObject)script), (int)startTerminal.getOffset());
                EObject astElement = node.getSemanticElement();
                ArrayList<String> retAndFPars = new ArrayList<String>();
                if (astElement instanceof LiteralOrComputedPropertyName) {
                    if (astElement.eContainer() instanceof N4MethodDeclaration) {
                        N4MethodDeclaration methodDecl = (N4MethodDeclaration)astElement.eContainer();
                        this.getRetAndFPars(retAndFPars, methodDecl);
                    }
                } else if (astElement instanceof N4MethodDeclaration) {
                    N4MethodDeclaration methodDecl = (N4MethodDeclaration)astElement;
                    this.getRetAndFPars(retAndFPars, methodDecl);
                }
                return retAndFPars;
            });
        }
        return retAndfparNames;
    }

    private void getRetAndFPars(List<String> retAndFPars, N4MethodDeclaration methodDecl) {
        if (methodDecl.getReturnTypeRef() != null) {
            if (methodDecl.getReturnTypeRef().getDeclaredType() instanceof VoidTypeImpl) {
                retAndFPars.add("void");
            } else {
                retAndFPars.add("return");
            }
        } else {
            TFunction tfunction = methodDecl.getDefinedFunction();
            if (tfunction != null) {
                TypeRef returnTypeRef = tfunction.getReturnTypeRef();
                if (!(returnTypeRef == null || TypeUtils.isVoid((TypeArgument)returnTypeRef) || returnTypeRef instanceof DeferredTypeRef || returnTypeRef instanceof BoundThisTypeRef)) {
                    retAndFPars.add("return");
                } else {
                    retAndFPars.add("noReturn");
                }
            } else {
                retAndFPars.add("noReturn");
            }
        }
        for (FormalParameter fpar : methodDecl.getFpars()) {
            retAndFPars.add(fpar.getName());
        }
    }
}

