/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.helper;

import com.google.common.base.Stopwatch;
import com.google.inject.Injector;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.n4js.binaries.nodejs.JavaBinary;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.binaries.nodejs.YarnBinary;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.helper.CliTools;
import org.eclipse.n4js.cli.helper.ProcessResult;
import org.eclipse.n4js.cli.helper.TestProcessBuilder;
import org.eclipse.n4js.utils.io.OutputRedirection;
import org.eclipse.n4js.utils.process.ProcessExecutor;

public class TestProcessExecuter {
    private final boolean inheritIO;
    private final boolean ignoreFailure;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private final TestProcessBuilder testProcessBuilder;
    private final ProcessExecutor processExecutor;

    public TestProcessExecuter(Injector injector, boolean inheritIO, boolean ignoreFailure, long timeout, TimeUnit unit) {
        this.inheritIO = inheritIO;
        this.ignoreFailure = ignoreFailure;
        this.timeout = timeout;
        this.timeoutUnit = unit;
        NodeJsBinary nodeJsBinary = (NodeJsBinary)injector.getInstance(NodeJsBinary.class);
        NpmBinary npmBinary = (NpmBinary)injector.getInstance(NpmBinary.class);
        YarnBinary yarnBinary = (YarnBinary)injector.getInstance(YarnBinary.class);
        JavaBinary javaBinary = (JavaBinary)injector.getInstance(JavaBinary.class);
        this.testProcessBuilder = new TestProcessBuilder(nodeJsBinary, npmBinary, yarnBinary, javaBinary);
        this.processExecutor = (ProcessExecutor)injector.getInstance(ProcessExecutor.class);
    }

    public ProcessResult runNodejs(Path workingDir, Map<String, String> environment, Path runFile, String ... options) {
        return this.joinProcess("node", () -> this.testProcessBuilder.nodejsRun(workingDir, environment, runFile, options));
    }

    public ProcessResult npmRun(Path workingDir, Map<String, String> environment, String ... options) {
        return this.joinProcess("npm", () -> this.testProcessBuilder.npmRun(workingDir, environment, options));
    }

    public ProcessResult yarnRun(Path workingDir, Map<String, String> environment, String ... options) {
        return this.joinProcess("yarn", () -> this.testProcessBuilder.yarnRun(workingDir, environment, options));
    }

    public ProcessResult n4jscRun(Path workingDir, Map<String, String> environment, N4jscOptions options) {
        return this.joinProcess("n4jsc.jar", () -> this.testProcessBuilder.n4jscRun(workingDir, environment, options));
    }

    public ProcessResult run(Path workingDir, Map<String, String> environment, Path executable, String ... options) {
        return this.joinProcess(executable.getFileName().toString(), () -> this.testProcessBuilder.run(workingDir, environment, executable, options));
    }

    private ProcessResult joinProcess(String executableName, Supplier<ProcessBuilder> pbs) {
        ProcessResult result;
        block6: {
            ProcessBuilder processBuilder = pbs.get();
            File workingDir = processBuilder.directory();
            List<String> command = processBuilder.command();
            result = new ProcessResult();
            result.command = String.join((CharSequence)" ", command);
            result.workingDir = workingDir.toString();
            Stopwatch sw = Stopwatch.createStarted();
            try {
                try {
                    Process process = processBuilder.start();
                    org.eclipse.n4js.utils.process.ProcessResult processResult = this.processExecutor.execute(process, executableName, this.inheritIO ? OutputRedirection.REDIRECT : OutputRedirection.SUPPRESS, this.timeout, this.timeoutUnit);
                    result.exitCode = process.exitValue();
                    result.stdOut = processResult.getStdOut();
                    result.errOut = processResult.getStdErr();
                }
                catch (Exception e) {
                    result.exception = e;
                    if (result.exitCode == Integer.MIN_VALUE) {
                        result.exitCode = -1;
                    }
                    result.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                result.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
                throw throwable;
            }
            result.duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
        }
        CliTools.trimOutputs(result, false);
        CliTools.checkForFailure(executableName, result, this.ignoreFailure);
        return result;
    }

    static interface ProcessSupplier {
        public Process get() throws ExecutionException;
    }
}

