/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.nodemodel;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.HiddenLeafNode;

public class SiblingIterable
implements Iterable<INode> {
    private final INode firstSibling;
    private final boolean skipHidden;

    public SiblingIterable(INode firstSibling) {
        this(firstSibling, true);
    }

    public SiblingIterable(INode firstSibling, boolean skipHidden) {
        this.firstSibling = firstSibling;
        this.skipHidden = skipHidden;
    }

    @Override
    public Iterator<INode> iterator() {
        return new Iterator<INode>(){
            private INode currNode;
            {
                this.currNode = this.skipHidden(SiblingIterable.this.firstSibling);
            }

            @Override
            public boolean hasNext() {
                return this.currNode != null;
            }

            @Override
            public INode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                INode result = this.currNode;
                this.currNode = this.skipHidden(this.currNode.getNextSibling());
                return result;
            }

            private INode skipHidden(INode node) {
                if (SiblingIterable.this.skipHidden) {
                    while (node instanceof HiddenLeafNode) {
                        node = node.getNextSibling();
                    }
                }
                return node;
            }
        };
    }
}

