/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.n4js.cli.N4jscException;
import org.eclipse.n4js.cli.N4jscExitCode;
import org.eclipse.n4js.cli.N4jscGoal;
import org.eclipse.n4js.cli.N4jscOptions;

public class N4jscOptionsValidater {
    public static N4jscExitCode validate(N4jscOptions options) throws N4jscException {
        N4jscOptionsValidater.validateGoalDefinitions(options);
        switch (options.getGoal()) {
            case version: {
                break;
            }
            case help: {
                break;
            }
            case lsp: {
                N4jscOptionsValidater.validateGoalLspOptions(options);
                break;
            }
            case clean: {
                N4jscOptionsValidater.validateGoalCleanOptions(options);
                break;
            }
            case compile: {
                N4jscOptionsValidater.validateGoalCompileOptions(options);
                break;
            }
            case api: {
                break;
            }
        }
        return N4jscExitCode.SUCCESS;
    }

    private static void validateGoalLspOptions(N4jscOptions options) throws N4jscException {
        if (options.getPort() < 1 || options.getPort() > 65535) {
            String msg = "Port is out of range: " + options.getPort();
            throw new N4jscException(N4jscExitCode.OPTION_INVALID, msg);
        }
        if (!options.getDirs().isEmpty()) {
            String msg = "Goal LSP does not expect superfluous directory argument";
            throw new N4jscException(N4jscExitCode.ARGUMENT_DIRS_INVALID, msg);
        }
    }

    private static void validateGoalCleanOptions(N4jscOptions options) throws N4jscException {
        N4jscOptionsValidater.validateFilesAndDirectories(options);
    }

    private static void validateGoalCompileOptions(N4jscOptions options) throws N4jscException {
        N4jscOptionsValidater.validateFilesAndDirectories(options);
        if (options.getTestCatalog() != null) {
            N4jscOptionsValidater.validateTestCatalogFile(options);
        }
        if (options.getPerformanceKey() != null || options.getPerformanceReport() != null) {
            N4jscOptionsValidater.validatePerformanceReport(options);
        }
    }

    private static void validateGoalDefinitions(N4jscOptions options) throws N4jscException {
        Map<String, N4jscOptions.GoalRequirements> nameFieldMap = options.getOptionNameToGoalRequirementMap();
        for (String name : options.getDefinedOptions().keySet()) {
            N4jscOptions.GoalRequirements goalRequirements;
            List<N4jscGoal> goals;
            boolean optionGoalRequirementMet;
            if (!nameFieldMap.containsKey(name) || (optionGoalRequirementMet = (goals = Arrays.asList((goalRequirements = nameFieldMap.get(name)).goals())).contains((Object)options.getGoal()))) continue;
            List goalNames = goals.stream().map(g -> g.name()).collect(Collectors.toList());
            String msg = "Given option " + name + " requires goal(s) " + String.join((CharSequence)", ", goalNames) + ", but goal " + (Object)((Object)options.getGoal()) + " was given.";
            throw new N4jscException(N4jscExitCode.OPTION_INVALID, msg);
        }
    }

    private static void validateFilesAndDirectories(N4jscOptions options) throws N4jscException {
        String msg;
        if (options.getDirs().isEmpty()) {
            String msg2 = "n4js directory(s) missing";
            throw new N4jscException(N4jscExitCode.ARGUMENT_DIRS_INVALID, msg2);
        }
        if (options.getDirs().size() > 1) {
            String msg3 = "Multiple project directories not supported.";
            throw new N4jscException(N4jscExitCode.ARGUMENT_DIRS_INVALID, msg3);
        }
        StringJoiner notExisting = new StringJoiner(",");
        StringJoiner neitherFileNorDir = new StringJoiner(",");
        for (File dir : options.getDirs()) {
            if (!dir.exists()) {
                notExisting.add(dir.toString());
                continue;
            }
            if (dir.isDirectory() || dir.isFile() && "package.json".equals(dir.getName())) continue;
            neitherFileNorDir.add(dir.toString());
        }
        if (!notExisting.toString().isEmpty()) {
            msg = "directory(s) do not exist: " + notExisting.toString();
            throw new N4jscException(N4jscExitCode.ARGUMENT_DIRS_INVALID, msg);
        }
        if (!neitherFileNorDir.toString().isEmpty()) {
            msg = "directory(s) are neither directory nor a package.json file: " + neitherFileNorDir.toString();
            throw new N4jscException(N4jscExitCode.ARGUMENT_DIRS_INVALID, msg);
        }
    }

    private static void validateTestCatalogFile(N4jscOptions options) throws N4jscException {
        if (options.getTestCatalog().exists()) {
            if (options.getTestCatalog().isDirectory()) {
                String msg = "The location of the test catalog file points to a directory and not to a file. " + options.getTestCatalog();
                throw new N4jscException(N4jscExitCode.TEST_CATALOG_ASSEMBLATION_ERROR, msg);
            }
            if (!options.getTestCatalog().delete()) {
                String msg = "Error while deleting existing test catalog file. " + options.getTestCatalog();
                throw new N4jscException(N4jscExitCode.TEST_CATALOG_ASSEMBLATION_ERROR, msg);
            }
        }
        try {
            if (!options.getTestCatalog().createNewFile()) {
                String msg = "Error while creating test catalog file at: " + options.getTestCatalog();
                throw new N4jscException(N4jscExitCode.TEST_CATALOG_ASSEMBLATION_ERROR, msg);
            }
        }
        catch (IOException e) {
            String msg = "Error while creating test catalog file. " + e.getMessage();
            throw new N4jscException(N4jscExitCode.TEST_CATALOG_ASSEMBLATION_ERROR, msg);
        }
        if (!options.getTestCatalog().exists() || !options.getTestCatalog().canWrite()) {
            String msg = "Cannot access test catalog file at: " + options.getTestCatalog();
            throw new N4jscException(N4jscExitCode.TEST_CATALOG_ASSEMBLATION_ERROR, msg);
        }
    }

    private static void validatePerformanceReport(N4jscOptions options) throws N4jscException {
        if (options.getPerformanceReport() != null && Strings.isNullOrEmpty((String)options.getPerformanceKey())) {
            String msg = "Missing performance key.";
            throw new N4jscException(N4jscExitCode.OPTION_INVALID, msg);
        }
    }
}

