/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.SetterDeclaration;
import org.eclipse.n4js.n4JS.TypedElement;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.AbstractProcessor;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TTypedElement;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
class TypeDeferredProcessor
extends AbstractProcessor {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;

    TypeDeferredProcessor() {
    }

    public void handleDeferredTypeRefs_preChildren(RuleEnvironment G, EObject obj, ASTMetaInfoCache cache) {
        TypeRef returnTypeRef;
        boolean _matched = false;
        if (obj instanceof N4MethodDeclaration) {
            Type _definedType_1;
            TMethod tMethod;
            _matched = true;
            returnTypeRef = ((N4MethodDeclaration)obj).getReturnTypeRef();
            boolean _isConstructor = ((N4MethodDeclaration)obj).isConstructor();
            if (_isConstructor) {
                Type _definedType = ((N4MethodDeclaration)obj).getDefinedType();
                TMethod tCtor = (TMethod)_definedType;
                if (tCtor != null) {
                    AbstractProcessor.assertTrueIfRigid(cache, "TMethod in TModule should be a constructor", tCtor.isConstructor());
                    TypeRef _returnTypeRef = tCtor.getReturnTypeRef();
                    AbstractProcessor.assertTrueIfRigid(cache, "return type of constructor in TModule should be a DeferredTypeRef", _returnTypeRef instanceof DeferredTypeRef);
                    ThisTypeRef implicitReturnTypeRef = TypeRefsFactory.eINSTANCE.createThisTypeRef();
                    TypeRef boundThisTypeRef = this.tsh.bindAndSubstituteThisTypeRef(G, obj, (TypeRef)implicitReturnTypeRef);
                    Procedures.Procedure0 _function = () -> {
                        tCtor.setReturnValueMarkedOptional(true);
                        tCtor.setReturnTypeRef((TypeRef)TypeUtils.copy((EObject)boundThisTypeRef));
                    };
                    EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{tCtor});
                }
            } else if (returnTypeRef instanceof ThisTypeRef && (tMethod = (TMethod)(_definedType_1 = ((N4MethodDeclaration)obj).getDefinedType())) != null) {
                TypeRef _returnTypeRef_1 = tMethod.getReturnTypeRef();
                AbstractProcessor.assertTrueIfRigid(cache, "return type of TMethod in TModule should be a DeferredTypeRef", _returnTypeRef_1 instanceof DeferredTypeRef);
                TypeRef boundThisTypeRef_1 = this.tsh.bindAndSubstituteThisTypeRef(G, (EObject)returnTypeRef, returnTypeRef);
                Procedures.Procedure0 _function_1 = () -> tMethod.setReturnTypeRef((TypeRef)TypeUtils.copy((EObject)boundThisTypeRef_1));
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function_1, (Object[])new Object[]{tMethod});
            }
        }
        if (!_matched && obj instanceof N4GetterDeclaration) {
            _matched = true;
            returnTypeRef = ((N4GetterDeclaration)obj).getDeclaredTypeRef();
            if (returnTypeRef instanceof ThisTypeRef) {
                TGetter tGetter = ((N4GetterDeclaration)obj).getDefinedGetter();
                TypeRef _declaredTypeRef = tGetter.getDeclaredTypeRef();
                AbstractProcessor.assertTrueIfRigid(cache, "return type of TGetter in TModule should be a DeferredTypeRef", _declaredTypeRef instanceof DeferredTypeRef);
                TypeRef boundThisTypeRef = this.tsh.getThisTypeAtLocation(G, (EObject)returnTypeRef);
                Procedures.Procedure0 _function = () -> tGetter.setDeclaredTypeRef((TypeRef)TypeUtils.copy((EObject)boundThisTypeRef));
                EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{tGetter});
            }
        }
    }

    public void handleDeferredTypeRefs_postChildren(RuleEnvironment G, EObject obj, ASTMetaInfoCache cache) {
        boolean _matched = false;
        if (obj instanceof ExportedVariableDeclaration) {
            _matched = true;
            TVariable tVariable = ((ExportedVariableDeclaration)obj).getDefinedVariable();
            this.setTypeRef((ExportedVariableDeclaration)obj, (TTypedElement)tVariable, false, G, cache);
        }
        if (!_matched && obj instanceof N4FieldDeclaration) {
            _matched = true;
            TField tField = ((N4FieldDeclaration)obj).getDefinedField();
            this.setTypeRef((N4FieldDeclaration)obj, (TTypedElement)tField, true, G, cache);
        }
        if (!_matched && obj instanceof FormalParameter) {
            _matched = true;
            EObject parent = ((FormalParameter)obj).eContainer();
            boolean _matched_1 = false;
            if (parent instanceof FunctionExpression) {
                _matched_1 = true;
            }
            if (!_matched_1 && parent instanceof PropertyMethodDeclaration) {
                _matched_1 = true;
            }
            if (!_matched_1 && parent instanceof FunctionDefinition) {
                _matched_1 = true;
                TFormalParameter tFPar = ((FormalParameter)obj).getDefinedTypeElement();
                TypeRef _typeRef = null;
                if (tFPar != null) {
                    _typeRef = tFPar.getTypeRef();
                }
                if (_typeRef instanceof DeferredTypeRef) {
                    this.setTypeRef((FormalParameter)obj, (TTypedElement)tFPar, true, G, cache);
                }
            }
            if (!_matched_1 && parent instanceof SetterDeclaration) {
                _matched_1 = true;
            }
            if (!_matched_1) {
                throw new IllegalArgumentException("Unsupported parent type of FormalParameter");
            }
        }
    }

    private <T extends TypableElement & TypedElement> void setTypeRef(T typedElem, TTypedElement tte, boolean useContext, RuleEnvironment G, ASTMetaInfoCache cache) {
        boolean _tripleEquals;
        TypeRef _declaredTypeRef = ((TypedElement)typedElem).getDeclaredTypeRef();
        boolean bl = _tripleEquals = _declaredTypeRef == null;
        if (_tripleEquals && tte != null) {
            String _name = typedElem.getClass().getName();
            String _plus = "return type of " + _name;
            String _plus_1 = String.valueOf(_plus) + " in TModule should be a DeferredTypeRef";
            TypeRef _typeRef = tte.getTypeRef();
            AbstractProcessor.assertTrueIfRigid(cache, _plus_1, _typeRef instanceof DeferredTypeRef);
            RuleEnvironment G2 = G;
            if (useContext) {
                ParameterizedTypeRef context = null;
                EObject _eContainer = tte.eContainer();
                if (_eContainer instanceof ContainerType) {
                    EObject _eContainer_1 = tte.eContainer();
                    context = TypeUtils.createTypeRef((Type)((ContainerType)_eContainer_1), (TypeArgument[])new TypeArgument[0]);
                }
                G2 = this.ts.createRuleEnvironmentForContext((TypeRef)context, RuleEnvironmentExtensions.getContextResource(G));
            }
            TypeRef fieldTypeRef = this.invokeTypeJudgmentToInferType(G2, typedElem);
            if (useContext) {
                fieldTypeRef = this.ts.substTypeVariables(G2, (TypeArgument)fieldTypeRef);
            }
            TypeRef fieldTypeRefSane = this.tsh.sanitizeTypeOfVariableFieldPropertyParameter(G, (TypeArgument)fieldTypeRef);
            Procedures.Procedure0 _function = () -> tte.setTypeRef((TypeRef)TypeUtils.copy((EObject)fieldTypeRefSane));
            EcoreUtilN4.doWithDeliver((boolean)false, (Procedures.Procedure0)_function, (Object[])new Object[]{tte});
        }
    }
}

