/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.lsp.FileVisitingAcceptor;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IFileSystemScanner;
import org.eclipse.xtext.util.RuntimeIOException;

@Singleton
public class FileSystemScanner
implements IFileSystemScanner {
    public void scan(URI root, IAcceptor<URI> acceptor) {
        File rootFile = new File(root.toFileString());
        if (rootFile.isDirectory()) {
            try {
                Path rootPath = rootFile.toPath();
                if (acceptor instanceof FileVisitingAcceptor) {
                    Files.walkFileTree(rootPath, (FileVisitingAcceptor)acceptor);
                } else {
                    Files.walk(rootPath, new FileVisitOption[0]).forEach(p -> {
                        File file = p.toFile();
                        if (!file.isDirectory()) {
                            acceptor.accept((Object)new FileURI(p.toFile()).toURI());
                        }
                    });
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }
}

