/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.packagejson.PackageJsonUtils;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSCache;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.validation.ResourceValidatorImpl;

public class N4JSResourceValidator
extends ResourceValidatorImpl {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private OperationCanceledManager operationCanceledManager;
    @Inject
    private N4JSCache n4jsCache;

    private List<Issue> doValidate(Resource resource, CheckMode mode, CancelIndicator cancelIndicator) {
        IN4JSProject project = (IN4JSProject)this.n4jsCore.findProject(resource.getURI()).orNull();
        if (project != null && !this.isValidFileTypeForProjectType(resource, project)) {
            Issue issue = N4JSResourceValidator.createInvalidFileTypeError(resource, project);
            return Collections.singletonList(issue);
        }
        if (this.n4jsCore.isNoValidate(resource.getURI())) {
            return Collections.emptyList();
        }
        if (resource instanceof N4JSResource) {
            N4JSResource resourceCasted = (N4JSResource)resource;
            if (resourceCasted.isOpaque()) {
                return Collections.emptyList();
            }
            try {
                resourceCasted.performPostProcessing(cancelIndicator);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (resourceCasted.isFullyProcessed() && resourceCasted.getPostProcessingThrowable() != null) {
                Throwable th = resourceCasted.getPostProcessingThrowable();
                if (this.operationCanceledManager.isOperationCanceledException(th)) {
                    return Collections.emptyList();
                }
                Issue issue = N4JSResourceValidator.createPostProcessingFailedError((Resource)resourceCasted, th);
                return Collections.singletonList(issue);
            }
        }
        return super.validate(resource, mode, cancelIndicator);
    }

    public List<Issue> validate(Resource resource, CheckMode mode, CancelIndicator cancelIndicator) {
        return this.n4jsCache.getOrElseUpdateIssues(this::doValidate, resource, mode, cancelIndicator);
    }

    protected void validate(Resource resource, CheckMode mode, CancelIndicator cancelIndicator, IAcceptor<Issue> acceptor) {
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            EObject firstElement = (EObject)contents.get(0);
            this.validate(resource, firstElement, mode, cancelIndicator, acceptor);
        }
    }

    private boolean isValidFileTypeForProjectType(Resource resource, IN4JSProject project) {
        ResourceType resourceType = ResourceType.getResourceType(resource);
        ProjectType projectType = project.getProjectType();
        return resourceType != ResourceType.JS && resourceType != ResourceType.JSX && resourceType != ResourceType.N4JS && resourceType != ResourceType.N4JSX || projectType != ProjectType.RUNTIME_LIBRARY && projectType != ProjectType.DEFINITION;
    }

    private static Issue createInvalidFileTypeError(Resource res, IN4JSProject project) {
        String projectTypeStr = PackageJsonUtils.getProjectTypeStringRepresentation(project.getProjectType());
        String msg = IssueCodes.getMessageForINVALID_FILE_TYPE_FOR_PROJECT_TYPE(projectTypeStr);
        return N4JSResourceValidator.createFileIssue(res, msg, "INVALID_FILE_TYPE_FOR_PROJECT_TYPE");
    }

    private static Issue createPostProcessingFailedError(Resource res, Throwable th) {
        String thKind = th instanceof Error ? "error" : (th instanceof Exception ? "exception" : "throwable");
        String thName = th.getClass().getSimpleName();
        String trace = "\n" + Stream.of(th.getStackTrace()).map(ste -> ste.toString()).collect(Collectors.joining("\n"));
        String msg = IssueCodes.getMessageForPOST_PROCESSING_FAILED(thKind, thName, String.valueOf(th.getMessage()) + trace);
        return N4JSResourceValidator.createFileIssue(res, msg, "POST_PROCESSING_FAILED");
    }

    private static Issue createFileIssue(Resource res, String message, String issueCode) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setCode(issueCode);
        issue.setSeverity(IssueCodes.getDefaultSeverity(issueCode));
        issue.setMessage(message);
        issue.setUriToProblem(res.getURI());
        issue.setType(CheckType.FAST);
        issue.setOffset(Integer.valueOf(0));
        issue.setLength(Integer.valueOf(0));
        issue.setLineNumber(Integer.valueOf(0));
        issue.setColumn(Integer.valueOf(0));
        return issue;
    }
}

