/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.inject.Inject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.n4js.ui.workingsets.WorkingSetManagerBroker;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;

public class SelectTopLevelElementActionGroup
extends ActionGroup {
    @Inject
    private WorkingSetManagerBroker workingSetManagerBroker;
    private MenuItem projectsItem;
    private MenuItem workingSetsItem;
    private boolean hasContributedToViewMenu = false;

    public void fillActionBars(IActionBars actionBars) {
        if (this.hasContributedToViewMenu) {
            return;
        }
        MenuManager topLevelSubMenu = new MenuManager("Top Level Elements");
        this.addActions((IMenuManager)topLevelSubMenu);
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.insertBefore("additions", (IContributionItem)topLevelSubMenu);
        this.hasContributedToViewMenu = true;
    }

    private void addActions(IMenuManager menuManager) {
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ContributionItem(){

            public void fill(Menu menu, int index) {
                SelectTopLevelElementActionGroup.this.projectsItem = new MenuItem(menu, 32);
                SelectTopLevelElementActionGroup.this.projectsItem.setText("Projects");
                SelectTopLevelElementActionGroup.this.projectsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).SelectTopLevelElementActionGroup.this.projectsItem.setSelection(true);
                        (this).SelectTopLevelElementActionGroup.this.workingSetsItem.setSelection(false);
                        (this).SelectTopLevelElementActionGroup.this.workingSetManagerBroker.setWorkingSetTopLevel(false);
                    }
                });
                if (!SelectTopLevelElementActionGroup.this.workingSetManagerBroker.isWorkingSetTopLevel()) {
                    SelectTopLevelElementActionGroup.this.projectsItem.setSelection(true);
                }
            }
        });
        menuManager.add((IContributionItem)new ContributionItem(){

            public void fill(Menu menu, int index) {
                SelectTopLevelElementActionGroup.this.workingSetsItem = new MenuItem(menu, 32);
                SelectTopLevelElementActionGroup.this.workingSetsItem.setText("Working Sets");
                SelectTopLevelElementActionGroup.this.workingSetsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).SelectTopLevelElementActionGroup.this.workingSetsItem.setSelection(true);
                        (this).SelectTopLevelElementActionGroup.this.projectsItem.setSelection(false);
                        (this).SelectTopLevelElementActionGroup.this.workingSetManagerBroker.setWorkingSetTopLevel(true);
                    }
                });
                if (SelectTopLevelElementActionGroup.this.workingSetManagerBroker.isWorkingSetTopLevel()) {
                    SelectTopLevelElementActionGroup.this.workingSetsItem.setSelection(true);
                }
            }
        });
    }
}

