/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SourceContainerType implements Enumerator
{
    SOURCE(0, "SOURCE", "SOURCE"),
    TEST(1, "TEST", "TEST"),
    EXTERNAL(2, "EXTERNAL", "EXTERNAL");

    public static final int SOURCE_VALUE = 0;
    public static final int TEST_VALUE = 1;
    public static final int EXTERNAL_VALUE = 2;
    private static final SourceContainerType[] VALUES_ARRAY;
    public static final List<SourceContainerType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SourceContainerType[]{SOURCE, TEST, EXTERNAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SourceContainerType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SourceContainerType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SourceContainerType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SourceContainerType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SourceContainerType get(int value) {
        switch (value) {
            case 0: {
                return SOURCE;
            }
            case 1: {
                return TEST;
            }
            case 2: {
                return EXTERNAL;
            }
        }
        return null;
    }

    private SourceContainerType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

