/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.projectModel.names;

import com.google.common.base.Preconditions;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;

public final class EclipseProjectName {
    private final String name;

    public EclipseProjectName(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((name.length() > 0 ? 1 : 0) != 0, (Object)name);
        Preconditions.checkArgument((boolean)URI.validSegment((String)name), (Object)name);
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        return this.toN4JSProjectName().getName();
    }

    public String getScope() {
        return this.toN4JSProjectName().getScope();
    }

    public N4JSProjectName toN4JSProjectName() {
        return new N4JSProjectName(ProjectDescriptionUtils.convertEclipseProjectNameToN4JSProjectName(this.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            throw new IllegalArgumentException("Cannot compare to type " + obj.getClass().getName());
        }
        EclipseProjectName other = (EclipseProjectName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }
}

