/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ts.findReferences.SimpleResourceAccess;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURICollector;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

public class FindReferenceHelper {
    @Inject
    private Provider<TargetURIs> targetURISetProvider;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private TargetURICollector collector;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public List<EObject> findReferences(EObject declaration, ResourceSet resourceSet) {
        declaration = this.getDeclaration(declaration);
        TargetURIs targets = this.getTargets(declaration);
        SimpleResourceAccess resourceAccess = new SimpleResourceAccess(resourceSet);
        IResourceDescriptions index = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
        ReferenceAcceptor acceptor = new ReferenceAcceptor();
        this.referenceFinder.findAllReferences(targets, (IReferenceFinder.IResourceAccess)resourceAccess, index, (IReferenceFinder.Acceptor)acceptor, null);
        return acceptor.results;
    }

    public List<EObject> findReferencesInResource(EObject declaration, Resource resource) {
        declaration = this.getDeclaration(declaration);
        TargetURIs targets = this.getTargets(declaration);
        ReferenceAcceptor acceptor = new ReferenceAcceptor();
        this.referenceFinder.findReferences((Predicate)targets, resource, (IReferenceFinder.Acceptor)acceptor, null);
        return acceptor.results;
    }

    private EObject getDeclaration(EObject declaration) {
        if (declaration instanceof ParameterizedTypeRef) {
            declaration = ((ParameterizedTypeRef)declaration).getDeclaredType();
        }
        return declaration;
    }

    private TargetURIs getTargets(EObject declaration) {
        ArrayList<Object> realTargets = new ArrayList<Object>();
        if (declaration instanceof TMember && ((TMember)declaration).isComposed()) {
            EList constituentMembers = ((TMember)declaration).getConstituentMembers();
            for (TMember tMember : constituentMembers) {
                realTargets.add(tMember);
            }
        } else {
            realTargets.add(declaration);
        }
        TargetURIs targets = (TargetURIs)this.targetURISetProvider.get();
        for (EObject eObject : realTargets) {
            this.collector.add(eObject, targets);
        }
        return targets;
    }

    static class ReferenceAcceptor
    implements IReferenceFinder.Acceptor {
        final ArrayList<EObject> results = Lists.newArrayList();

        ReferenceAcceptor() {
        }

        public void accept(EObject src, URI srcURI, EReference eRef, int idx, EObject tgtOrProxy, URI tgtURI) {
            this.results.add(src);
        }

        public void accept(IReferenceDescription description) {
        }
    }
}

