/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.GraphProvider;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ASTGraphProvider
implements GraphProvider<Object, Object> {
    private static final String[] SHOW_BUILT_IN = new String[0];
    private final String startTag = "/\\*\\*?";
    private final Pattern commentStartTagRegex = Pattern.compile("(?s)/\\*\\*?.*");

    private boolean showBuiltInContains(EObject eObj) {
        return org.eclipse.xtext.util.Arrays.contains((Object[])SHOW_BUILT_IN, (Object)this.getName(eObj));
    }

    @Override
    public List<Object> getElements(Object input) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (input instanceof ResourceSet) {
            List<Resource> ignoredResources = this.getElements((ResourceSet)input, result);
            result.addAll(ignoredResources);
        } else if (input instanceof EObject) {
            ASTGraphProvider.collectAllMatchingNoResolve((EObject)input, result, this::hasNoHideComment, false);
        }
        return result;
    }

    private List<Resource> getElements(ResourceSet resSet, List<Object> result) {
        ArrayList<Resource> ignoredResources = new ArrayList<Resource>();
        for (Resource res : new ArrayList(resSet.getResources())) {
            boolean isFirstResource = result.isEmpty();
            String uriStr = res.getURI().toString();
            if (isFirstResource || uriStr.endsWith(".n4js") || uriStr.endsWith(".n4jsd")) {
                this.getElementsForN4JSs(result, res);
                continue;
            }
            if (SHOW_BUILT_IN.length > 0 && (uriStr.endsWith("builtin_js.n4ts") || uriStr.endsWith("builtin_n4.n4ts"))) {
                this.getElementsForBuiltIns(result, ignoredResources, res);
                continue;
            }
            ignoredResources.add(res);
        }
        return ignoredResources;
    }

    private void getElementsForN4JSs(List<Object> result, Resource res) {
        result.add(res);
        for (EObject currRoot : ASTGraphProvider.getContentsNoResolve(res)) {
            ASTGraphProvider.collectAllMatchingNoResolve(currRoot, result, this::hasNoHideComment, false);
        }
    }

    private void getElementsForBuiltIns(List<Object> result, List<Resource> ignoredResources, Resource res) {
        ArrayList namedElementsToShow = new ArrayList();
        for (EObject currRoot : ASTGraphProvider.getContentsNoResolve(res)) {
            ASTGraphProvider.collectAllMatchingNoResolve(currRoot, namedElementsToShow, this::showBuiltInContains, true);
        }
        if (!namedElementsToShow.isEmpty()) {
            result.add(res);
            for (EObject currRoot : namedElementsToShow) {
                ASTGraphProvider.collectAllMatchingNoResolve(currRoot, result, this::hasNoHideComment, false);
            }
        } else {
            ignoredResources.add(res);
        }
    }

    @Override
    public Node getNode(Object element) {
        String desc;
        String name;
        String type;
        if (element instanceof Resource) {
            URI uri = ((Resource)element).getURI();
            type = "Resource";
            name = uri != null ? uri.lastSegment() : null;
            desc = null;
        } else if (element instanceof EObject) {
            EObject eobj = (EObject)element;
            if (eobj.eIsProxy()) {
                type = "PROXY(" + eobj.eClass().getName() + ")";
                name = null;
                desc = "proxy URI:\n" + EcoreUtil.getURI((EObject)eobj);
            } else {
                type = eobj.eClass().getName();
                name = this.getName(eobj);
                desc = this.getDescription(eobj);
            }
        } else {
            type = element.getClass().getSimpleName();
            name = null;
            desc = null;
        }
        String title = String.valueOf(type) + (name != null ? " " + name : "");
        return new Node(element, title, desc);
    }

    @Override
    public List<Edge> getConnectedEdges(Node node, List<Node> allNodes) {
        ArrayList<Edge> result = new ArrayList<Edge>();
        Object element = node.getElement();
        if (element instanceof Resource) {
            this.getConnectedEdgesForResource(node, allNodes, result, (Resource)element);
        } else if (element instanceof EObject) {
            this.getConnectedEdgesForEObject(node, allNodes, result, (EObject)element);
        }
        return result;
    }

    private void getConnectedEdgesForEObject(Node node, List<Node> allNodes, List<Edge> result, EObject eobj) {
        Node nodeForResource;
        for (EReference currRef : eobj.eClass().getEAllReferences()) {
            if (currRef.isDerived() || currRef.isContainer()) continue;
            if (currRef.isMany()) {
                Object targets = eobj.eGet((EStructuralFeature)currRef, false);
                if (!(targets instanceof Collection)) continue;
                this.getConnectedEdgesForEObjectManyCase(node, allNodes, result, currRef, targets);
                continue;
            }
            Object target = eobj.eGet((EStructuralFeature)currRef, false);
            if (!(target instanceof EObject)) continue;
            this.getConnectedEdgesForEObjectSingleCase(node, allNodes, result, currRef, target);
        }
        Node nodeForElement = GraphUtils.getNodeForElement(eobj.eContainer(), allNodes);
        if (eobj.eResource() != null && eobj.eContainer() != null && nodeForElement == null && (nodeForResource = GraphUtils.getNodeForElement(eobj.eResource(), allNodes)) != null) {
            Edge edge = new Edge("<... containment omitted ...>", false, nodeForResource, Collections.singletonList(node), Collections.emptyList());
            result.add(edge);
        }
    }

    private void getConnectedEdgesForEObjectManyCase(Node node, List<Node> allNodes, List<Edge> result, EReference currRef, Object targets) {
        ArrayList<Node> targetNodes = new ArrayList<Node>();
        ArrayList<String> targetNodesExternal = new ArrayList<String>();
        for (Object currTarget : (Collection)targets) {
            Node currTargetNode = GraphUtils.getNodeForElement(currTarget, allNodes);
            if (currTargetNode != null) {
                targetNodes.add(currTargetNode);
                continue;
            }
            if (!(currTarget instanceof EObject) || !((EObject)currTarget).eIsProxy()) continue;
            targetNodesExternal.add(EcoreUtil.getURI((EObject)((EObject)currTarget)).toString());
        }
        if (!targetNodes.isEmpty() || !targetNodesExternal.isEmpty()) {
            Edge edge = new Edge(currRef.getName(), !currRef.isContainment(), node, targetNodes, targetNodesExternal);
            result.add(edge);
        }
    }

    private void getConnectedEdgesForEObjectSingleCase(Node node, List<Node> allNodes, List<Edge> result, EReference currRef, Object target) {
        Node targetNode = GraphUtils.getNodeForElement(target, allNodes);
        String targetNodeExternal = targetNode == null && ((EObject)target).eIsProxy() ? EcoreUtil.getURI((EObject)((EObject)target)).toString() : null;
        if (targetNode != null || targetNodeExternal != null) {
            Edge edge = new Edge(currRef.getName(), !currRef.isContainment(), node, ASTGraphProvider.asCollection(targetNode), ASTGraphProvider.asCollection(targetNodeExternal));
            result.add(edge);
        }
    }

    private void getConnectedEdgesForResource(Node node, List<Node> allNodes, List<Edge> result, Resource res) {
        List<EObject> targets = ASTGraphProvider.getContentsNoResolve(res);
        List<Node> targetNodes = GraphUtils.getNodesForElements(targets, allNodes);
        if (!targetNodes.isEmpty()) {
            Edge edge = new Edge("contents", false, node, targetNodes, Collections.emptyList());
            result.add(edge);
        }
    }

    private String getName(EObject eobj) {
        if (eobj != null) {
            EList eAllAttributes = eobj.eClass().getEAllAttributes();
            for (EAttribute attr : eAllAttributes) {
                Object value;
                if (!"name".equals(attr.getName()) || !((value = eobj.eGet((EStructuralFeature)attr, false)) instanceof String)) continue;
                return (String)value;
            }
        }
        return null;
    }

    private String getDescription(EObject eobj) {
        ArrayList<String> lines = new ArrayList<String>();
        for (EAttribute a : eobj.eClass().getEAllAttributes()) {
            String line = String.valueOf(a.getName()) + ": \t" + eobj.eGet((EStructuralFeature)a);
            lines.add(line);
        }
        String result = lines.isEmpty() ? null : Joiner.on((char)'\n').join(lines);
        return result;
    }

    private static final void collectAllMatchingNoResolve(EObject obj, List<? super EObject> addHere, Predicate<EObject> predicate, boolean collectBelowNonMatching) {
        boolean matches = predicate.test(obj);
        if (matches) {
            addHere.add((EObject)obj);
        }
        if (matches || collectBelowNonMatching) {
            Iterator<EObject> i = ASTGraphProvider.eContentsNoResolve(obj);
            while (i.hasNext()) {
                ASTGraphProvider.collectAllMatchingNoResolve(i.next(), addHere, predicate, collectBelowNonMatching);
            }
        }
    }

    private static final List<EObject> getContentsNoResolve(Resource res) {
        return Arrays.asList((EObject[])Iterators.toArray(ASTGraphProvider.eContentsNoResolve(res), EObject.class));
    }

    private static final Iterator<EObject> eContentsNoResolve(Resource res) {
        return ((InternalEList)res.getContents()).basicIterator();
    }

    private static final Iterator<EObject> eContentsNoResolve(EObject obj) {
        return ((InternalEList)obj.eContents()).basicIterator();
    }

    private boolean hasNoHideComment(EObject eobj) {
        return !this.hasHideComment(eobj);
    }

    private boolean hasHideComment(EObject eobj) {
        if (eobj.eIsProxy()) {
            return false;
        }
        String doc = this.getDocumentation(eobj);
        return doc != null && doc.contains("HIDE");
    }

    private String getDocumentation(EObject object) {
        if (object.eContainer() == null) {
            return null;
        }
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        if (node != null) {
            for (ILeafNode leafNode : node.getLeafNodes()) {
                String comment;
                if (!leafNode.isHidden()) break;
                EObject grammarElem = leafNode.getGrammarElement();
                if (!(grammarElem instanceof TerminalRule) || !"ML_COMMENT".equalsIgnoreCase(((TerminalRule)grammarElem).getName()) || !this.commentStartTagRegex.matcher(comment = leafNode.getText()).matches()) continue;
                return leafNode.getText();
            }
        }
        return null;
    }

    private static final <T> Collection<T> asCollection(T object) {
        return object != null ? Collections.singletonList(object) : Collections.emptyList();
    }
}

