/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.lsp.FileVisitingAcceptor;
import org.eclipse.n4js.internal.lsp.N4JSProjectConfig;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.lsp.IN4JSSourceFolder;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.IFileSystemScanner;

public class N4JSSourceFolder
implements IN4JSSourceFolder {
    private final IN4JSSourceContainer delegate;
    private final N4JSProjectConfig project;

    public N4JSSourceFolder(N4JSProjectConfig project, IN4JSSourceContainer delegate) {
        this.project = project;
        this.delegate = delegate;
    }

    @Override
    public N4JSProjectConfig getProject() {
        return this.project;
    }

    public String getName() {
        return this.delegate.getRelativeLocation();
    }

    public URI getPath() {
        return ((SafeURI)this.delegate.getLocation().withTrailingPathDelimiter()).toURI();
    }

    public List<URI> getAllResources(IFileSystemScanner scanner) {
        final ArrayList<URI> uris = new ArrayList<URI>();
        URI projectBase = this.getPath();
        scanner.scan(projectBase, (IAcceptor)new FileVisitingAcceptor(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.endsWith("node_modules")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public void accept(URI uri) {
                uris.add(uri);
            }
        });
        return uris;
    }
}

