/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ComparisonChain;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.ide.xtext.server.DiagnosticIssueConverter;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class IssueAcceptor {
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private XWorkspaceManager workspaceManager;
    @Inject
    private DiagnosticIssueConverter diagnosticIssueConverter;
    private LanguageClient client;

    public void connect(LanguageClient languageClient) {
        this.client = languageClient;
    }

    public void disconnect() {
        this.client = null;
    }

    public void publishDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        if (this.client != null) {
            PublishDiagnosticsParams publishDiagnosticsParams = new PublishDiagnosticsParams();
            publishDiagnosticsParams.setUri(this.uriExtensions.toUriString(uri));
            List<Diagnostic> diags = this.toDiagnostics(uri, issues);
            publishDiagnosticsParams.setDiagnostics(diags);
            this.client.publishDiagnostics(publishDiagnosticsParams);
        }
    }

    protected List<Diagnostic> toDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        IProjectConfig projectConfig;
        ISourceFolder iSourceFolder;
        if (!this.workspaceManager.isDocumentOpen(uri) && (iSourceFolder = (projectConfig = this.workspaceManager.getWorkspaceConfig().findProjectContaining(uri)).findSourceFolderContaining(uri)) == null) {
            return Collections.emptyList();
        }
        if (IterableExtensions.isEmpty(issues)) {
            return Collections.emptyList();
        }
        ArrayList<Diagnostic> sortedDiags = new ArrayList<Diagnostic>();
        for (Issue issue : issues) {
            if (issue.getSeverity() == Severity.IGNORE) continue;
            sortedDiags.add(this.diagnosticIssueConverter.toDiagnostic(issue, this.workspaceManager::getDocument));
        }
        Comparator<Diagnostic> comparator = new Comparator<Diagnostic>(){

            @Override
            public int compare(Diagnostic d1, Diagnostic d2) {
                Position p1 = d1.getRange().getStart();
                Position p2 = d2.getRange().getStart();
                int result = ComparisonChain.start().compare(p1.getLine(), p2.getLine()).compare(p2.getCharacter(), p2.getCharacter()).result();
                return result;
            }
        };
        Collections.sort(sortedDiags, comparator);
        return sortedDiags;
    }
}

