/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.packagejson;

import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;

public class PolyFilledProvision {
    public final String descriptionPolyfill;
    public final String descriptionStandard;
    public final N4JSProjectName library;
    public final IEObjectDescription ieoDescrOfPolyfill;
    public final JSONStringLiteral libraryProjectReferenceLiteral;

    public PolyFilledProvision(N4JSProjectName library, JSONStringLiteral libProjectDescription, IEObjectDescription ieoDescrOfPolyfill) {
        this.library = library;
        this.libraryProjectReferenceLiteral = libProjectDescription;
        this.ieoDescrOfPolyfill = ieoDescrOfPolyfill;
        this.descriptionPolyfill = ieoDescrOfPolyfill.toString();
        this.descriptionStandard = PolyFilledProvision.withoutPolyfillAsString(ieoDescrOfPolyfill.getQualifiedName());
    }

    public static String withoutPolyfillAsString(QualifiedName qualifiedName) {
        String last = qualifiedName.getLastSegment();
        String poly = qualifiedName.skipLast(1).getLastSegment();
        assert (N4TSQualifiedNameProvider.POLYFILL_SEGMENT.equals(poly));
        QualifiedName ret = qualifiedName.skipLast(2).append(last);
        return ret.toString();
    }

    public static boolean isPolyfill(IEObjectDescription description) {
        return description.getQualifiedName().getSegments().stream().anyMatch(it -> N4TSQualifiedNameProvider.POLYFILL_SEGMENT.equals(it));
    }
}

