/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.n4js.transpiler.sourcemap.LineMappings;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;

class MappingEntryIterator
implements Iterator<MappingEntry> {
    final Iterator<? extends LineMappings> lineIter;
    Iterator<MappingEntry> columnIter;

    MappingEntryIterator(Iterator<? extends LineMappings> lineIter) {
        this.lineIter = lineIter;
        this.udpateColumnIter();
    }

    private void udpateColumnIter() {
        while (this.lineIter.hasNext()) {
            LineMappings lineMappings = this.lineIter.next();
            if (lineMappings == null) continue;
            this.columnIter = lineMappings.iterator();
            if (!this.columnIter.hasNext()) continue;
            return;
        }
        this.columnIter = null;
    }

    @Override
    public boolean hasNext() {
        return this.columnIter != null;
    }

    @Override
    public MappingEntry next() {
        if (this.columnIter == null) {
            throw new NoSuchElementException("no more mappings can be iterated");
        }
        MappingEntry next = this.columnIter.next();
        if (!this.columnIter.hasNext()) {
            this.udpateColumnIter();
        }
        return next;
    }
}

