/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.base.Strings;
import java.util.List;
import org.eclipse.n4js.ts.typeRefs.TypeRef;

public class StructuralTypingResult {
    public final boolean value;
    public final String message;
    final boolean isN4ObjectOnLeftWithDefSite;

    public static StructuralTypingResult failureDefSiteWithN4Object(String message) {
        return new StructuralTypingResult(false, message, true);
    }

    public static StructuralTypingResult failure(String message) {
        return new StructuralTypingResult(false, message, false);
    }

    public static StructuralTypingResult result(TypeRef left, TypeRef right, List<String> missingMembers, List<String> wrongMembersErrors) {
        if (missingMembers.isEmpty() && wrongMembersErrors.isEmpty()) {
            return StructuralTypingResult.success();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(left.getTypeRefAsString()) + " is not a structural subtype of " + right.getTypeRefAsString() + ": ");
        if (!missingMembers.isEmpty()) {
            sb.append("missing " + missingMembers.get(0));
            if (missingMembers.size() > 1) {
                sb.append(" and " + (missingMembers.size() - 1) + " more");
            }
        }
        if (!wrongMembersErrors.isEmpty()) {
            if (!missingMembers.isEmpty()) {
                sb.append("; ");
            }
            sb.append(wrongMembersErrors.get(0));
            if (wrongMembersErrors.size() > 1) {
                sb.append(" and " + (wrongMembersErrors.size() - 1) + " more problems");
            }
        }
        return StructuralTypingResult.failure(sb.toString());
    }

    public static StructuralTypingResult success() {
        return new StructuralTypingResult(true);
    }

    StructuralTypingResult(boolean value) {
        this(value, null, false);
    }

    StructuralTypingResult(boolean value, String message, boolean isN4ObjectOnLeftWithDefSite) {
        this.value = value;
        this.message = message;
        this.isN4ObjectOnLeftWithDefSite = isN4ObjectOnLeftWithDefSite;
    }

    public boolean isValue() {
        return this.value;
    }

    public boolean hasMessage() {
        return !Strings.isNullOrEmpty((String)this.message);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isN4ObjectOnLeftWithDefSite() {
        return this.isN4ObjectOnLeftWithDefSite;
    }
}

