/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainerReference;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemMessageObject;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.ISystemViewInputProvider;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemHelpers;
import org.eclipse.rse.internal.ui.view.SystemSelectRemoteObjectAPIProviderImpl;
import org.eclipse.rse.internal.ui.view.SystemViewResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.filters.actions.SystemNewFilterAction;
import org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFilterName;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.IContextObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewFilterReferenceAdapter
extends AbstractSystemViewAdapter {
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        ISubSystemConfigurationAdapter adapter;
        ISystemFilter filter = this.getFilter(selection.getFirstElement());
        ISubSystemConfiguration ssFactory = this.getSubSystemConfiguration(filter);
        ISubSystem currentSubSystem = this.getFilterReference(selection.getFirstElement()).getSubSystem();
        IHost currentConnection = currentSubSystem.getHost();
        ssFactory.setConnection(currentConnection);
        ssFactory.setCurrentSelection(selection.toArray());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISubSystemConfigurationAdapter)ssFactory.getAdapter((Class)clazz)) != null) {
            IAction action;
            int idx;
            IAction[] actions = adapter.getFilterActions(menu, selection, shell, menuGroup, ssFactory, filter);
            if (actions != null) {
                idx = 0;
                while (idx < actions.length) {
                    action = actions[idx];
                    if (action instanceof SystemNewFilterAction) {
                        menu.appendToGroup("group.new", (IContributionItem)new Separator());
                    }
                    menu.add(menuGroup, action);
                    ++idx;
                }
            }
            if ((actions = adapter.getFilterReferenceActions(menu, selection, shell, menuGroup, ssFactory, this.getFilterReference(selection.getFirstElement()))) != null) {
                idx = 0;
                while (idx < actions.length) {
                    action = actions[idx];
                    menu.add(menuGroup, action);
                    ++idx;
                }
            }
        }
    }

    private ISubSystemConfiguration getSubSystemConfiguration(ISystemFilter filter) {
        return SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)filter);
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof ISystemFilterReference) {
            return (ISubSystem)((ISystemFilterReference)element).getProvider();
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        ImageDescriptor filterImage = null;
        ISystemFilter filter = this.getFilter(element);
        if (filter.getProvider() != null) {
            ISubSystemConfigurationAdapter adapter;
            ISystemFilterPoolManagerProvider iSystemFilterPoolManagerProvider = filter.getProvider();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISubSystemConfigurationAdapter)iSystemFilterPoolManagerProvider.getAdapter((Class)clazz)) != null) {
                filterImage = adapter.getSystemFilterImage(filter);
            }
        }
        if (filterImage == null) {
            filterImage = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon");
        }
        return filterImage;
    }

    private ISystemFilterReference getFilterReference(Object element) {
        return (ISystemFilterReference)element;
    }

    private ISystemFilter getFilter(Object element) {
        return this.getFilterReference(element).getReferencedFilter();
    }

    public String getText(Object element) {
        return this.getFilter(element).getName();
    }

    public String getName(Object element) {
        return this.getFilter(element).getName();
    }

    public String getAbsoluteName(Object element) {
        ISystemFilterPoolReference filterPoolReference = this.getFilterReference(element).getParentSystemFilterReferencePool();
        ISystemViewElementAdapter adapter = SystemAdapterHelpers.getViewAdapter(filterPoolReference);
        String parentAbsoluteName = adapter != null ? adapter.getAbsoluteName(filterPoolReference) : "";
        return String.valueOf(parentAbsoluteName) + "." + this.getName(element);
    }

    public String getType(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemConfiguration(filter);
        return ssParentFactory.getTranslatedFilterTypeProperty(filter);
    }

    public Object getParent(Object element) {
        ISystemFilterReference fr = this.getFilterReference(element);
        ISystemFilterContainerReference parentContainer = fr.getParent();
        if (parentContainer instanceof ISystemFilterReference) {
            return parentContainer;
        }
        boolean showFPs = SystemPreferencesManager.getShowFilterPools();
        if (showFPs) {
            return parentContainer;
        }
        return fr.getProvider();
    }

    public Object[] getChildren(IAdaptable element, IProgressMonitor monitor) {
        return this.internalGetChildren(element, monitor);
    }

    public Object[] getChildren(IContextObject element, IProgressMonitor monitor) {
        Object adapter;
        Object[] children = this.getChildren(element.getModelObject(), monitor);
        if (children == null) {
            return null;
        }
        ISubSystem subsystem = element.getSubSystem();
        ISubSystemConfiguration configuration = subsystem.getSubSystemConfiguration();
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = iAdapterManager.getAdapter((Object)configuration, (Class)clazz)) instanceof ISubSystemConfigurationAdapter) {
            children = ((ISubSystemConfigurationAdapter)adapter).applyViewFilters(element, children);
        }
        return children;
    }

    protected Object[] internalGetChildren(Object element, IProgressMonitor monitor) {
        Object[] children = null;
        final ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        boolean promptable = referencedFilter.isPromptable();
        final ISubSystem ss = fRef.getSubSystem();
        final ISubSystemConfiguration ssf = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)referencedFilter);
        if (promptable) {
            final Object[] pchildren = new SystemMessageObject[1];
            final Object pelement = element;
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        ISubSystemConfigurationAdapter adapter;
                        ISystemFilter newFilter;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.rse.ui.subsystems.ISubSystemConfigurationAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((newFilter = (adapter = (ISubSystemConfigurationAdapter)ssf.getAdapter((Class)clazz)).createFilterByPrompting(ssf, fRef, SystemViewFilterReferenceAdapter.this.getShell())) == null) {
                            pchildren[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, pelement);
                        } else {
                            pchildren[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1102"), 4, pelement);
                            ISystemFilterReference sfr = fRef.getParentSystemFilterReferencePool().getExistingSystemFilterReference(ss, newFilter);
                            ISystemViewInputProvider inputProvider = SystemViewFilterReferenceAdapter.this.getInput();
                            if (sfr != null && inputProvider != null && inputProvider.getViewer() != null) {
                                SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)sfr, 105, null);
                                Viewer v = (Viewer)inputProvider.getViewer();
                                if (v instanceof ISystemResourceChangeListener) {
                                    RSEUIPlugin.getTheSystemRegistryUI().postEvent((ISystemResourceChangeListener)v, (ISystemResourceChangeEvent)event);
                                }
                            }
                        }
                    }
                    catch (Exception exc) {
                        pchildren[0] = new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, pelement);
                        SystemBasePlugin.logError("Exception prompting for filter ", exc);
                    }
                }
            });
            return pchildren;
        }
        Object[] nestedFilterReferences = fRef.getSystemFilterReferences(ss);
        int nbrFilterStrings = referencedFilter.getFilterStringCount();
        if (nbrFilterStrings == 0) {
            return nestedFilterReferences;
        }
        String[] filterStrings = referencedFilter.getFilterStrings();
        try {
            SystemSelectRemoteObjectAPIProviderImpl ip;
            ISystemViewInputProvider inputProvider = this.getInput();
            if (inputProvider != null && inputProvider instanceof SystemSelectRemoteObjectAPIProviderImpl && filterStrings != null && filterStrings.length > 0 && (ip = (SystemSelectRemoteObjectAPIProviderImpl)inputProvider).filtersNeedDecoration(element)) {
                String[] adorned = new String[filterStrings.length];
                int idx = 0;
                while (idx < filterStrings.length) {
                    adorned[idx] = ip.decorateFilterString(element, filterStrings[idx]);
                    ++idx;
                }
                filterStrings = adorned;
            }
            boolean doQuery = true;
            if (!referencedFilter.isTransient() && ssf.supportsFilterCaching() && !fRef.isStale() && fRef.hasContents((ISystemContentsType)SystemChildrenContentsType.getInstance())) {
                doQuery = false;
                children = fRef.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance());
                if (children != null) {
                    if (children.length == 0) {
                        doQuery = true;
                        fRef.markStale(true);
                    } else {
                        int i = 0;
                        while (i < children.length && !doQuery) {
                            Object child = children[i];
                            if (child instanceof ISystemContainer) {
                                if (((ISystemContainer)child).isStale()) {
                                    doQuery = true;
                                    fRef.markStale(true);
                                }
                            } else if (child instanceof ISystemMessageObject && ((ISystemMessageObject)child).isTransient()) {
                                doQuery = true;
                                fRef.markStale(true);
                            }
                            ++i;
                        }
                    }
                }
            }
            if (doQuery) {
                Object[] allChildren = null;
                allChildren = monitor == null ? ss.resolveFilterStrings(filterStrings, (IProgressMonitor)new NullProgressMonitor()) : ss.resolveFilterStrings(filterStrings, monitor);
                if (allChildren != null) {
                    if (allChildren.length == 1 && allChildren[0] instanceof ISystemMessageObject) {
                        return allChildren;
                    }
                    if (nestedFilterReferences != null) {
                        int nbrNestedFilters = nestedFilterReferences.length;
                        children = new Object[nbrNestedFilters + allChildren.length];
                        int idx = 0;
                        idx = 0;
                        while (idx < nbrNestedFilters) {
                            children[idx] = nestedFilterReferences[idx];
                            ++idx;
                        }
                        int jdx = 0;
                        while (jdx < allChildren.length) {
                            children[idx++] = allChildren[jdx];
                            ++jdx;
                        }
                        if (!referencedFilter.isTransient() && ssf.supportsFilterCaching()) {
                            fRef.setContents((ISystemContentsType)SystemChildrenContentsType.getInstance(), children);
                        }
                    }
                }
            }
        }
        catch (InterruptedException exc) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1067"), 1, element)};
            SystemBasePlugin.logDebugMessage(this.getClass().getName(), "Filter resolving cancelled by user.");
        }
        catch (Exception exc) {
            children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage("RSEG1098"), 0, element)};
            SystemBasePlugin.logError("Exception resolving filters' strings ", exc);
            return null;
        }
        return this.checkForEmptyList(children, element, true);
    }

    public boolean hasChildren(IAdaptable element) {
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        ISubSystemConfiguration factory = this.getSubSystemConfiguration(referencedFilter);
        if (factory.supportsFilterChildren()) {
            int nbrNestedFilters = referencedFilter.getSystemFilterCount();
            int nbrFilterStrings = referencedFilter.getFilterStringCount();
            return nbrNestedFilters > 0 || nbrFilterStrings > 0;
        }
        return false;
    }

    public boolean isPromptable(Object element) {
        boolean promptable = false;
        ISystemFilter filter = this.getFilter(element);
        promptable = filter.isPromptable();
        if (!promptable && SystemViewFilterReferenceAdapter.isCommandFilter(filter)) {
            promptable = true;
        }
        return promptable;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equalsIgnoreCase("filterType")) {
            ISystemFilterReference ref = this.getFilterReference(target);
            String type = ref.getReferencedFilter().getType();
            if (type == null || type.length() == 0) {
                return false;
            }
            return value.equals(type);
        }
        if (name.equalsIgnoreCase("showChangeFilterStringPropertyPage")) {
            ISystemFilterReference ref = this.getFilterReference(target);
            ISubSystemConfiguration ssf = SubSystemHelpers.getParentSubSystemConfiguration((ISystemFilter)ref.getReferencedFilter());
            if (value.equals("true")) {
                return ssf.showChangeFilterStringsPropertyPage(ref.getReferencedFilter());
            }
            return !ssf.showChangeFilterStringsPropertyPage(ref.getReferencedFilter());
        }
        return super.testAttribute(target, name, value);
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        if (propertyDescriptorArray == null) {
            int nbrOfProperties = 4;
            propertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            int idx = 0;
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParentPool", SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTPOOL_TOOLTIP);
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterParent", SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPARENTFILTER_TOOLTIP);
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterstringsCount", SystemViewResources.RESID_PROPERTY_FILTERSTRINGS_COUNT_LABEL, SystemViewResources.RESID_PROPERTY_FILTERSTRINGS_COUNT_TOOLTIP);
            SystemViewFilterReferenceAdapter.propertyDescriptorArray[++idx] = SystemViewFilterReferenceAdapter.createSimplePropertyDescriptor("org.eclipse.rse.ui.filterConnectionPrivate", SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_IS_CONNECTIONPRIVATE_LABEL, SystemViewResources.RESID_PROPERTY_FILTERPOOLREFERENCE_IS_CONNECTIONPRIVATE_TOOLTIP);
        }
        return propertyDescriptorArray;
    }

    protected Object internalGetPropertyValue(Object key) {
        String name = (String)key;
        ISystemFilter filter = this.getFilter(this.propertySourceInput);
        if (name.equals("org.eclipse.rse.ui.filterstringsCount")) {
            int nbrFilterStrings = filter.getFilterStringCount();
            return Integer.toString(nbrFilterStrings);
        }
        if (name.equals("org.eclipse.rse.ui.filterParent")) {
            ISystemFilter parent = filter.getParentFilter();
            if (parent != null) {
                return parent.getName();
            }
            return this.getTranslatedNotApplicable();
        }
        if (name.equals("org.eclipse.rse.ui.filterParentPool")) {
            ISystemFilterPool parent = filter.getParentFilterPool();
            if (parent != null) {
                return parent.getName();
            }
            return this.getTranslatedNotApplicable();
        }
        if (name.equals("org.eclipse.rse.ui.filterConnectionPrivate")) {
            ISystemFilterPool parent = filter.getParentFilterPool();
            return parent.getOwningParentName() == null ? this.getTranslatedNo() : this.getTranslatedYes();
        }
        return null;
    }

    public boolean canDelete(Object element) {
        ISystemFilter filter = this.getFilter(element);
        return !filter.isNonDeletable();
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        ISystemFilter filter = this.getFilter(element);
        ISystemFilterPoolManager fpMgr = filter.getSystemFilterPoolManager();
        fpMgr.deleteSystemFilter(filter);
        return true;
    }

    public boolean canRename(Object element) {
        ISystemFilter filter = this.getFilter(element);
        return !filter.isNonRenamable();
    }

    public boolean doRename(Shell shell, Object element, String name, IProgressMonitor monitor) throws Exception {
        ISystemFilter filter = this.getFilter(element);
        ISystemFilterPoolManager fpMgr = filter.getSystemFilterPoolManager();
        fpMgr.renameSystemFilter(filter, name);
        return true;
    }

    public ISystemValidator getNameValidator(Object element) {
        ISystemFilter parentFilter;
        ISystemFilter filter = null;
        ISystemFilterPool pool = null;
        String[] filterNames = null;
        if (element instanceof ISystemFilterReference) {
            filter = this.getFilter(element);
            pool = filter.getParentFilterPool();
            if (pool != null) {
                filterNames = pool.getSystemFilterNames();
            } else {
                parentFilter = filter.getParentFilter();
                filterNames = parentFilter.getSystemFilterNames();
            }
        } else if (element instanceof ISystemFilter) {
            filter = (ISystemFilter)element;
            pool = filter.getParentFilterPool();
            if (pool != null) {
                filterNames = pool.getSystemFilterNames();
            } else {
                parentFilter = filter.getParentFilter();
                filterNames = parentFilter.getSystemFilterNames();
            }
        } else {
            pool = (ISystemFilterPool)element;
            filterNames = pool.getSystemFilterNames();
        }
        ValidatorFilterName nameValidator = new ValidatorFilterName(filterNames);
        return nameValidator;
    }

    public String getCanonicalNewName(Object element, String newName) {
        ISystemFilterReference fRef = (ISystemFilterReference)element;
        ISystemFilter filter = fRef.getReferencedFilter();
        String mgrName = filter.getSystemFilterPoolManager().getName();
        return (String.valueOf(mgrName) + "." + filter.getParentFilterPool().getName() + "." + newName).toUpperCase();
    }

    public boolean showOpenViewActions(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemConfiguration(filter);
        return !filter.isPromptable() && !ssParentFactory.supportsCommands();
    }

    public boolean showGenericShowInTableAction(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemConfiguration(filter);
        return ssParentFactory.showGenericShowInTableOnFilter() && !filter.isPromptable() && !ssParentFactory.supportsCommands();
    }

    public boolean showRefresh(Object element) {
        ISystemFilter filter = this.getFilter(element);
        ISubSystemConfiguration ssParentFactory = this.getSubSystemConfiguration(filter);
        return ssParentFactory.showRefreshOnFilter() && !filter.isPromptable() && !ssParentFactory.supportsCommands();
    }

    public String getMementoHandle(Object element) {
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        ISystemFilterPool pool = referencedFilter.getParentFilterPool();
        String handle = String.valueOf(pool.getReferenceName()) + "=";
        ISystemFilter parentFilter = referencedFilter.getParentFilter();
        while (parentFilter != null) {
            handle = String.valueOf(handle) + parentFilter.getName() + ";";
            parentFilter = parentFilter.getParentFilter();
        }
        handle = String.valueOf(handle) + referencedFilter.getName();
        return handle;
    }

    public String getInputMementoHandle(Object element) {
        Object parent = ((ISystemFilterReference)element).getParent();
        ISystemViewElementAdapter parentAdapter = SystemAdapterHelpers.getViewAdapter(parent, this.getViewer());
        boolean showFPs = SystemPreferencesManager.getShowFilterPools();
        if (parent instanceof ISystemFilterPoolReference && !showFPs) {
            parent = parentAdapter.getParent(parent);
            parentAdapter = SystemAdapterHelpers.getViewAdapter(parent, this.getViewer());
        }
        return String.valueOf(parentAdapter.getInputMementoHandle(parent)) + "///" + this.getMementoHandle(element);
    }

    public String getMementoHandleKey(Object element) {
        return "FRef";
    }

    public boolean saveExpansionState(Object element) {
        boolean savable = true;
        ISystemFilterReference fRef = this.getFilterReference(element);
        ISystemFilter referencedFilter = fRef.getReferencedFilter();
        boolean promptable = referencedFilter.isPromptable();
        if (promptable) {
            savable = false;
        } else if (SystemViewFilterReferenceAdapter.isCommandFilter(referencedFilter)) {
            savable = false;
        }
        return savable;
    }

    public static boolean isCommandFilter(ISystemFilter filter) {
        ISubSystemConfiguration ssf = (ISubSystemConfiguration)filter.getProvider();
        return ssf.supportsCommands();
    }

    public boolean canDrag(Object element) {
        ISystemFilterReference fRef = this.getFilterReference(element);
        return fRef != null && this.getSubSystemConfiguration(fRef.getReferencedFilter()).supportsFilterStringExport();
    }

    public boolean canDrop(Object element) {
        ISubSystemConfiguration factory;
        ISystemFilterReference fRef = this.getFilterReference(element);
        if (fRef != null && (factory = this.getSubSystemConfiguration(fRef.getReferencedFilter())).supportsDropInFilters()) {
            if (factory.providesCustomDropInFilters()) {
                return true;
            }
            if (!fRef.getReferencedFilter().isNonChangable() && factory.supportsMultiStringFilters()) {
                return true;
            }
        }
        return false;
    }

    public ISystemResourceSet doDrag(SystemRemoteResourceSet set, IProgressMonitor monitor) {
        return set;
    }

    public Object doDrag(Object element, boolean sameSystemType, IProgressMonitor monitor) {
        return element;
    }

    public Object doDrop(Object from, Object to, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        if (sameSystemType) {
            ISystemFilterReference fRef = this.getFilterReference(to);
            ISystemFilter filter = fRef.getReferencedFilter();
            if (from instanceof ISystemFilterReference) {
                ISystemFilter srcFilter = ((ISystemFilterReference)from).getReferencedFilter();
                String[] filterStrings = srcFilter.getFilterStrings();
                int i = 0;
                while (i < filterStrings.length) {
                    filter.addFilterString(filterStrings[i]);
                    ++i;
                }
                return fRef;
            }
            if (from instanceof IAdaptable) {
                ISystemRemoteElementAdapter radapter;
                String newFilterStr;
                IAdaptable iAdaptable = (IAdaptable)from;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((newFilterStr = (radapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)).getFilterStringFor(from)) != null) {
                    filter.addFilterString(newFilterStr);
                    return fRef;
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        ISystemRemoteElementAdapter adapter;
        ISystemFilterReference filterRef;
        if (!sameSystem) {
            return src instanceof IResource;
        }
        if (!(target instanceof ISystemFilterReference) || !this.getSubSystemConfiguration((filterRef = (ISystemFilterReference)target).getReferencedFilter()).supportsMultiStringFilters()) return false;
        if (src instanceof ISystemFilterReference) {
            String srcType = ((ISystemFilterReference)src).getReferencedFilter().getType();
            String targetType = filterRef.getReferencedFilter().getType();
            if (targetType == null || srcType == null) return true;
            if (!targetType.equals(srcType)) return false;
            return true;
        }
        if (!(src instanceof IAdaptable)) return false;
        IAdaptable iAdaptable = (IAdaptable)src;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)iAdaptable.getAdapter((Class)clazz)) == null || adapter.getFilterStringFor(src) == null) return false;
        return true;
    }

    public boolean supportsDeferredQueries(ISubSystem subSys) {
        return subSys.getSubSystemConfiguration().supportsDeferredQueries();
    }

    public boolean isRemote(Object element) {
        return false;
    }

    public boolean namesAreEqual(Object element, String newName) {
        return this.getName(element).equals(newName);
    }
}

