/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xtext.serializer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;

class ValueWrappingMap<K, V>
extends ForwardingMap<K, V> {
    private final Function<? super V, ? extends V> wrapper;
    private final Map<K, V> delegate;

    public ValueWrappingMap(Function<? super V, ? extends V> wrapper) {
        this(Maps.newHashMap(), wrapper);
    }

    public ValueWrappingMap(Map<K, V> delegate, Function<? super V, ? extends V> wrapper) {
        this.wrapper = (Function)Preconditions.checkNotNull(wrapper);
        this.delegate = (Map)Preconditions.checkNotNull(delegate);
    }

    protected Map<K, V> delegate() {
        return this.delegate;
    }

    public V put(K key, V value) {
        return (V)super.put(key, this.wrapper.apply(value));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        super.putAll(Maps.transformValues(map, v -> this.wrapper.apply(v)));
    }
}

