/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.formatting2;

import java.util.List;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;

public class FixedMultilineCommentReplacer
extends CommentReplacer {
    private final boolean multiline;

    public FixedMultilineCommentReplacer(IComment comment) {
        super(comment);
        this.multiline = comment.isMultiline();
    }

    public void configureWhitespace(WhitespaceReplacer leading, WhitespaceReplacer trailing) {
        if (this.multiline) {
            this.enforceNewLine(leading);
            this.enforceNewLine(trailing);
        } else {
            this.enforceSingleSpace(leading);
            this.enforceSingleSpace(trailing);
        }
    }

    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        String indentationString;
        if (!this.multiline) {
            return context;
        }
        IComment comment = this.getComment();
        ITextRegionAccess access = comment.getTextRegionAccess();
        List lines = comment.getLineRegions();
        String oldIndentation = ((ILineRegion)lines.get(0)).getIndentation().getText();
        String newIndentation = indentationString = context.getIndentationString();
        int i = 1;
        while (i < lines.size() - 1) {
            ITextSegment line = (ITextSegment)lines.get(i);
            String text = line.getText();
            ITextSegment target = text.startsWith(oldIndentation) ? access.regionForOffset(line.getOffset(), oldIndentation.length()) : access.regionForOffset(line.getOffset(), 0);
            context.addReplacement(target.replaceWith(newIndentation));
            ++i;
        }
        if (lines.size() > 1) {
            ILineRegion line = (ILineRegion)lines.get(lines.size() - 1);
            context.addReplacement(line.getIndentation().replaceWith(String.valueOf(indentationString) + " "));
        }
        return context;
    }

    protected void enforceNewLine(WhitespaceReplacer replacer) {
        if (replacer.getRegion().getOffset() <= 0) {
            return;
        }
        Integer min = replacer.getFormatting().getNewLineMin();
        if (min == null || min < 1) {
            replacer.getFormatting().setNewLinesMin(Integer.valueOf(1));
        }
    }

    protected void enforceSingleSpace(WhitespaceReplacer replacer) {
        if (replacer.getRegion().getOffset() <= 0) {
            return;
        }
        String space = replacer.getFormatting().getSpace();
        if (space == null || space.length() < 1) {
            replacer.getFormatting().setSpace(" ");
        }
    }
}

