/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription;
import org.eclipse.n4js.scoping.accessModifiers.MemberVisibilityChecker;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.xtext.scoping.FilterWithErrorMarkerScope;
import org.eclipse.n4js.xtext.scoping.IEObjectDescriptionWithError;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class VisibilityAwareMemberScope
extends FilterWithErrorMarkerScope {
    private final MemberVisibilityChecker checker;
    private final EObject context;
    private final TypeRef receiverType;
    private final HashMap<String, String> accessModifierSuggestionStore = new HashMap();

    public VisibilityAwareMemberScope(IScope parent, MemberVisibilityChecker checker, TypeRef receiverType, EObject context) {
        super(parent);
        this.checker = checker;
        this.receiverType = receiverType;
        this.context = context;
    }

    protected IEObjectDescriptionWithError wrapFilteredDescription(IEObjectDescription description) {
        String uriString = description.getEObjectURI().toString();
        return new InvisibleMemberDescription(description, this.accessModifierSuggestionStore.get(uriString));
    }

    protected boolean isAccepted(IEObjectDescription description) {
        EObject proxyOrInstance = description.getEObjectOrProxy();
        if (proxyOrInstance != null && !proxyOrInstance.eIsProxy()) {
            if (proxyOrInstance instanceof TMember) {
                TMember member = (TMember)proxyOrInstance;
                MemberVisibilityChecker.MemberVisibility result = this.checker.isVisible(this.context, this.receiverType, member);
                if (!result.visibility) {
                    String uriString = description.getEObjectURI().toString();
                    this.accessModifierSuggestionStore.put(uriString, result.accessModifierSuggestion);
                }
                return result.visibility;
            }
            if (proxyOrInstance instanceof TEnumLiteral) {
                return this.checker.isEnumLiteralVisible(this.context, this.receiverType);
            }
        }
        return true;
    }
}

