/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AssignmentOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionAnnotationList;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.TypedElement;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.UnaryOperator;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.extensions.ExpressionExtensions;
import org.eclipse.n4js.scoping.N4JSScopeProvider;
import org.eclipse.n4js.scoping.members.TypingStrategyFilter;
import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeCompareHelper;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.Result;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class N4JSTypeValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private TypeCompareHelper typeCompareHelper;
    @Inject
    private N4JSScopeProvider n4jsScopeProvider;
    @Inject
    protected ContainerTypesHelper containerTypesHelper;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkGenericDeclarationType(GenericDeclaration declaration) {
        TObjectPrototype functionType = RuleEnvironmentExtensions.functionType(RuleEnvironmentExtensions.newRuleEnvironment((EObject)declaration));
        Consumer<TypeVariable> _function = typeVar -> {
            Type declType;
            TypeRef ub = typeVar.getDeclaredUpperBound();
            if (ub != null && (declType = ub.getDeclaredType()) instanceof ContainerType && declType.isFinal()) {
                if (declType == functionType) {
                    return;
                }
                String message = IssueCodes.getMessageForCLF_UPPER_BOUND_FINAL(declType.getName(), typeVar.getName());
                this.addIssue(message, (EObject)ub, (EStructuralFeature)TypeRefsPackage.Literals.PARAMETERIZED_TYPE_REF__DECLARED_TYPE, "CLF_UPPER_BOUND_FINAL", new String[0]);
            }
        };
        IterableExtensions.filterNull((Iterable)declaration.getTypeVars()).forEach(_function);
    }

    @Check
    public void checkTModuleCreated(Script script) {
        ICompositeNode rootNode;
        boolean _tripleEquals;
        TModule _module = script.getModule();
        boolean bl = _tripleEquals = _module == null;
        if (_tripleEquals && (rootNode = NodeModelUtils.getNode((EObject)script)) != null) {
            this.addIssue(IssueCodes.getMessageForTYS_MISSING(), (EObject)script, rootNode.getOffset(), rootNode.getLength(), "TYS_MISSING");
        }
    }

    @Check
    public void checkParameterizedTypeRef(ParameterizedTypeRef paramTypeRef) {
        boolean isInTypeTypeRef;
        Type declaredType = paramTypeRef.getDeclaredType();
        if (declaredType == null || declaredType.eIsProxy()) {
            return;
        }
        boolean bl = isInTypeTypeRef = paramTypeRef.eContainer() instanceof TypeTypeRef || paramTypeRef.eContainer() instanceof Wildcard && paramTypeRef.eContainer().eContainer() instanceof TypeTypeRef;
        if (isInTypeTypeRef) {
            this.internalCheckValidTypeInTypeTypeRef(paramTypeRef);
        } else {
            this.internalCheckTypeArguments((List<? extends TypeVariable>)declaredType.getTypeVars(), (List<? extends TypeArgument>)paramTypeRef.getTypeArgs(), false, (IdentifiableElement)declaredType, (EObject)paramTypeRef, (EStructuralFeature)TypeRefsPackage.eINSTANCE.getParameterizedTypeRef_DeclaredType());
        }
        this.internalCheckDynamic(paramTypeRef);
        this.internalCheckStructuralPrimitiveTypeRef(paramTypeRef);
    }

    private void internalCheckStructuralPrimitiveTypeRef(ParameterizedTypeRef typeRef) {
        if (typeRef.getDeclaredType() instanceof PrimitiveType && !Objects.equal((Object)typeRef.getTypingStrategy(), (Object)TypingStrategy.NOMINAL)) {
            this.addIssue(IssueCodes.getMessageForTYS_STRUCTURAL_PRIMITIVE(), (EObject)typeRef, "TYS_STRUCTURAL_PRIMITIVE");
        }
    }

    private void internalCheckValidTypeInTypeTypeRef(ParameterizedTypeRef paramTypeRef) {
        boolean _not;
        boolean _isEmpty = paramTypeRef.getTypeArgs().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.addIssue(IssueCodes.getMessageForAST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF(), (EObject)paramTypeRef, "AST_NO_TYPE_ARGS_IN_CLASSIFIERTYPEREF");
        } else if (paramTypeRef instanceof FunctionTypeRef) {
            this.addIssue(IssueCodes.getMessageForAST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF(), (EObject)paramTypeRef, "AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF");
        } else {
            Type _declaredType = paramTypeRef.getDeclaredType();
            if (_declaredType instanceof TFunction) {
                this.addIssue(IssueCodes.getMessageForAST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF(), (EObject)paramTypeRef, "AST_NO_FUNCTIONTYPEREFS_IN_CLASSIFIERTYPEREF");
            }
        }
    }

    @Check
    public void checkThisTypeRef(ThisTypeRef thisTypeRef) {
        boolean _not;
        if (thisTypeRef instanceof BoundThisTypeRef) {
            return;
        }
        boolean bl = _not = !this.isUsedStructurallyAsFormalParametersInTheConstructor(thisTypeRef) && !this.isUsedAtCovariantPositionInClassifierDeclaration(thisTypeRef) && !this.isUsedInVariableWithSyntaxError(thisTypeRef);
        if (_not) {
            this.addIssue(IssueCodes.getMessageForAST_THIS_WRONG_PLACE(), (EObject)thisTypeRef, "AST_THIS_WRONG_PLACE");
        }
    }

    private boolean isUsedStructurallyAsFormalParametersInTheConstructor(ThisTypeRef thisTypeRef) {
        boolean _isUseSiteStructuralTyping = thisTypeRef.isUseSiteStructuralTyping();
        if (_isUseSiteStructuralTyping) {
            EObject methodOrConstructor;
            EObject _eContainer = null;
            if (thisTypeRef != null) {
                _eContainer = thisTypeRef.eContainer();
            }
            EObject _eContainer_1 = null;
            if (_eContainer != null) {
                _eContainer_1 = _eContainer.eContainer();
            }
            if ((methodOrConstructor = _eContainer_1) instanceof N4MethodDeclaration && methodOrConstructor != null && ((N4MethodDeclaration)methodOrConstructor).isConstructor()) {
                return true;
            }
        }
        return false;
    }

    private boolean isUsedAtCovariantPositionInClassifierDeclaration(ThisTypeRef thisTypeRef) {
        N4ClassifierDeclaration classifierDecl = (N4ClassifierDeclaration)EcoreUtil2.getContainerOfType((EObject)thisTypeRef, N4ClassifierDeclaration.class);
        if (classifierDecl != null) {
            N4MemberDeclaration memberDecl;
            if (classifierDecl instanceof N4InterfaceDeclaration && (memberDecl = (N4MemberDeclaration)EcoreUtil2.getContainerOfType((EObject)thisTypeRef, N4MemberDeclaration.class)) != null && memberDecl.isStatic()) {
                return false;
            }
            Variance varianceOfPos = N4JSLanguageUtils.getVarianceOfPosition((TypeRef)thisTypeRef);
            if (varianceOfPos != null) {
                return varianceOfPos == Variance.CO;
            }
        }
        return false;
    }

    private boolean isUsedInVariableWithSyntaxError(ThisTypeRef ref) {
        EObject container = ref.eContainer();
        if (container instanceof VariableDeclaration) {
            String _name = ((VariableDeclaration)container).getName();
            return _name == null;
        }
        return false;
    }

    @Check
    public void checkSymbolReference(TypeRef typeRef) {
        EObject parent;
        TObjectPrototype _symbolObjectType;
        boolean _tripleEquals;
        Resource _eResource = null;
        if (typeRef != null) {
            _eResource = typeRef.eResource();
        }
        BuiltInTypeScope bits = BuiltInTypeScope.get((ResourceSet)_eResource.getResourceSet());
        Type _declaredType = typeRef.getDeclaredType();
        boolean bl = _tripleEquals = _declaredType == (_symbolObjectType = bits.getSymbolObjectType());
        if (_tripleEquals && (!((parent = typeRef.eContainer()) instanceof ParameterizedPropertyAccessExpression) || ((ParameterizedPropertyAccessExpression)parent).getTarget() != typeRef)) {
            this.addIssue(IssueCodes.getMessageForBIT_SYMBOL_INVALID_USE(), (EObject)typeRef, "BIT_SYMBOL_INVALID_USE");
        }
    }

    public void internalCheckDynamic(ParameterizedTypeRef ref) {
        Type t;
        boolean _isDynamic = ref.isDynamic();
        if (_isDynamic && (t = ref.getDeclaredType()) instanceof PrimitiveType && !(t instanceof AnyType)) {
            this.addIssue(IssueCodes.getMessageForTYS_PRIMITIVE_TYPE_DYNAMIC(t.getName()), (EObject)ref, "TYS_PRIMITIVE_TYPE_DYNAMIC");
        }
    }

    @Check
    public void checkTypeHiddenByTypeVariable(GenericDeclaration genDecl) {
        boolean _not;
        boolean _isEmpty = genDecl.getTypeVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean staticAccess = genDecl instanceof N4MemberDeclaration && ((N4MemberDeclaration)genDecl).isStatic();
            IScope scope = this.n4jsScopeProvider.getTypeScope(genDecl.eContainer(), staticAccess);
            Consumer<TypeVariable> _function = it -> {
                boolean _not_1;
                boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)it.getName());
                boolean bl = _not_1 = !_isNullOrEmpty;
                if (_not_1) {
                    EObject hiddenType;
                    IEObjectDescription hiddenTypeDscr = scope.getSingleElement(QualifiedName.create((String)it.getName()));
                    EObject _eObjectOrProxy = null;
                    if (hiddenTypeDscr != null) {
                        _eObjectOrProxy = hiddenTypeDscr.getEObjectOrProxy();
                    }
                    if ((hiddenType = _eObjectOrProxy) instanceof Type && !AbstractDescriptionWithError.isErrorDescription_XTEND_MVN_BUG_HACK(hiddenTypeDscr)) {
                        String message = IssueCodes.getMessageForVIS_TYPE_PARAMETER_HIDES_TYPE(it.getName(), this.keywordProvider.keyword(hiddenType));
                        this.addIssue(message, (EObject)it, "VIS_TYPE_PARAMETER_HIDES_TYPE");
                    }
                }
            };
            genDecl.getTypeVars().forEach(_function);
        }
    }

    @Check
    public void checkCompoundAssignmentGetterSetterClashOnLhs(AssignmentExpression assExpr) {
        IdentifiableElement prop;
        if (assExpr.getOp() == null || assExpr.getOp() == AssignmentOperator.ASSIGN) {
            return;
        }
        Expression lhs = assExpr.getLhs();
        if (lhs instanceof ParameterizedPropertyAccessExpression && (prop = ((ParameterizedPropertyAccessExpression)lhs).getProperty()) instanceof TSetter) {
            Type targetType;
            TSetter setter = (TSetter)prop;
            TypeRef _tau = this.ts.tau((TypableElement)((ParameterizedPropertyAccessExpression)lhs).getTarget());
            Type _declaredType = null;
            if (_tau != null) {
                _declaredType = _tau.getDeclaredType();
            }
            if ((targetType = _declaredType) instanceof ContainerType) {
                TMember m = this.containerTypesHelper.fromContext((EObject)assExpr).findMember((ContainerType)targetType, setter.getName(), false, setter.isStatic());
                if (m == null) {
                    String message = IssueCodes.getMessageForTYS_COMPOUND_MISSING_GETTER();
                    this.addIssue(message, (EObject)assExpr.getLhs(), "TYS_COMPOUND_MISSING_GETTER");
                } else if (m instanceof TGetter) {
                    TypeRef typeOfGetter;
                    TGetter getter = (TGetter)m;
                    RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)assExpr);
                    TypeRef expectedType = this.ts.expectedType(G, (EObject)assExpr, assExpr.getRhs());
                    TypeRef typeOfGetterRAW = TypeUtils.getMemberTypeRef((TMember)getter);
                    if (expectedType != null && typeOfGetterRAW != null && (typeOfGetter = this.ts.substTypeVariables(G, typeOfGetterRAW)) != null) {
                        Result result = this.ts.subtype(G, (TypeArgument)typeOfGetter, (TypeArgument)expectedType);
                        this.createTypeError(result, (EObject)assExpr.getLhs());
                    }
                }
            }
        }
    }

    @Check
    public void checkInconsistentInterfaceImplementationOrExtension(N4ClassifierDeclaration classifierDecl) {
        Type _definedType = classifierDecl.getDefinedType();
        TClassifier tClassifier = (TClassifier)_definedType;
        if (tClassifier == null) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)classifierDecl);
        RuleEnvironmentExtensions.recordInconsistentSubstitutions(G);
        Consumer<ParameterizedTypeRef> _function = it -> this.tsh.addSubstitutions(G, (TypeRef)it);
        tClassifier.getSuperClassifierRefs().forEach(_function);
        Set<TypeVariable> _typeMappingKeys = RuleEnvironmentExtensions.getTypeMappingKeys(G);
        for (TypeVariable tv : _typeMappingKeys) {
            boolean _not_1;
            boolean _not;
            TypeRef subst;
            if (tv.isDeclaredCovariant() || tv.isDeclaredContravariant() || !((subst = this.ts.substTypeVariables(G, (TypeRef)TypeUtils.createTypeRef((Type)tv, (TypeArgument[])new TypeArgument[0]))) instanceof UnknownTypeRef)) continue;
            List<TypeRef> badSubst = RuleEnvironmentExtensions.getInconsistentSubstitutions(G, tv);
            boolean _isEmpty = badSubst.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            boolean _allEqualType = this.tsh.allEqualType(G, (TypeRef[])Conversions.unwrapArray(badSubst, TypeRef.class));
            boolean bl2 = _not_1 = !_allEqualType;
            if (!_not_1) continue;
            String _xifexpression = null;
            _xifexpression = tClassifier instanceof TClass ? "implement" : "extend";
            String mode = _xifexpression;
            EObject _eContainer = tv.eContainer();
            String ifcName = ((TInterface)_eContainer).getName();
            String _name = tv.getName();
            String tvName = "invariant " + _name;
            Functions.Function1 _function_1 = it -> it.getTypeRefAsString();
            String typeRefsStr = IterableExtensions.join((Iterable)ListExtensions.map(badSubst, (Functions.Function1)_function_1), (CharSequence)", ");
            String message = IssueCodes.getMessageForCLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY(mode, ifcName, tvName, typeRefsStr);
            this.addIssue(message, (EObject)classifierDecl, (EStructuralFeature)N4JSPackage.eINSTANCE.getN4TypeDeclaration_Name(), "CLF_IMPLEMENT_EXTEND_SAME_INTERFACE_INCONSISTENTLY", new String[0]);
        }
    }

    @Check
    public void checkTypeMatchesExpectedType(Expression expression) {
        boolean _not;
        boolean _requireCheckTypeMatchesExpectedType = this.jsVariantHelper.requireCheckTypeMatchesExpectedType((EObject)expression);
        boolean bl = _not = !_requireCheckTypeMatchesExpectedType;
        if (_not) {
            return;
        }
        if (expression instanceof ExpressionAnnotationList) {
            return;
        }
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expression);
        TypeRef inferredType = this.ts.type(G, (TypableElement)expression);
        if (inferredType instanceof UnknownTypeRef) {
            return;
        }
        G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)expression);
        TypeRef expectedTypeRef = this.ts.expectedType(G, expression.eContainer(), expression);
        if (expectedTypeRef != null) {
            ArrowFunction singleExprArrowFunction = N4JSASTUtils.getContainingSingleExpressionArrowFunction((Expression)expression);
            if (singleExprArrowFunction != null && TypeUtils.isVoid((TypeArgument)inferredType)) {
                boolean _tripleEquals;
                if (TypeUtils.isVoid((TypeArgument)expectedTypeRef) || singleExprArrowFunction.isReturnValueOptional()) {
                    return;
                }
                TypeRef _returnTypeRef = singleExprArrowFunction.getReturnTypeRef();
                boolean bl2 = _tripleEquals = _returnTypeRef == null;
                if (_tripleEquals) {
                    String message = IssueCodes.getMessageForFUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID();
                    this.addIssue(message, (EObject)expression, "FUN_SINGLE_EXP_LAMBDA_IMPLICIT_RETURN_ALLOWED_UNLESS_VOID");
                    return;
                }
            }
            this.internalCheckUseOfUndefinedExpression(G, expression, expectedTypeRef, inferredType);
            boolean writeAccess = ExpressionExtensions.isLeftHandSide((EObject)expression);
            if (writeAccess) {
                Result result = this.ts.subtype(G, (TypeArgument)expectedTypeRef, (TypeArgument)inferredType);
                boolean _isFailure = result.isFailure();
                if (_isFailure) {
                    String message_1 = IssueCodes.getMessageForTYS_NO_SUPERTYPE_WRITE_ACCESS(expectedTypeRef.getTypeRefAsString(), inferredType.getTypeRefAsString());
                    this.addIssue(message_1, (EObject)expression, "TYS_NO_SUPERTYPE_WRITE_ACCESS");
                }
            } else {
                Result result_1 = this.ts.subtype(G, (TypeArgument)inferredType, (TypeArgument)expectedTypeRef);
                boolean errorCreated = this.createTypeError(result_1, (EObject)expression);
                if (!errorCreated) {
                    this.internalCheckSuperfluousPropertiesInObjectLiteralRek(G, expectedTypeRef, expression);
                }
            }
        }
    }

    public void internalCheckSuperfluousPropertiesInObjectLiteralRek(RuleEnvironment G, TypeRef expectedTypeRef, Expression expression) {
        if (expression instanceof ObjectLiteral) {
            this.internalCheckSuperfluousPropertiesInObjectLiteral(expectedTypeRef, (ObjectLiteral)expression);
        } else if (expression instanceof ArrayLiteral) {
            boolean _not;
            boolean _isEmpty = expectedTypeRef.getTypeArgs().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                TypeArgument arrayElementType = (TypeArgument)expectedTypeRef.getTypeArgs().get(0);
                TypeRef typeArgTypeRef = this.ts.upperBoundWithReopenAndResolve(G, arrayElementType);
                EList _elements = ((ArrayLiteral)expression).getElements();
                for (ArrayElement arrElem : _elements) {
                    Expression arrExpr = arrElem.getExpression();
                    this.internalCheckSuperfluousPropertiesInObjectLiteralRek(G, typeArgTypeRef, arrExpr);
                }
            }
        }
    }

    public void internalCheckSuperfluousPropertiesInObjectLiteral(TypeRef typeRef, ObjectLiteral objectLiteral) {
        TypingStrategy typingStrategy = typeRef.getTypingStrategy();
        if (!Objects.equal((Object)typingStrategy, (Object)TypingStrategy.NOMINAL) && !Objects.equal((Object)typingStrategy, (Object)TypingStrategy.DEFAULT)) {
            boolean _isDynamic = typeRef.isDynamic();
            if (_isDynamic) {
                return;
            }
            Type type = typeRef.getDeclaredType();
            if (type == null && typeRef instanceof BoundThisTypeRef) {
                ParameterizedTypeRef _actualThisTypeRef = ((BoundThisTypeRef)typeRef).getActualThisTypeRef();
                Type _declaredType = null;
                if (_actualThisTypeRef != null) {
                    _declaredType = _actualThisTypeRef.getDeclaredType();
                }
                type = _declaredType;
            }
            if (!(type instanceof ContainerType)) {
                return;
            }
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)objectLiteral);
            EList structuralMembers = typeRef.getStructuralMembers();
            if (structuralMembers.isEmpty() && Objects.equal((Object)type, (Object)RuleEnvironmentExtensions.objectType(G))) {
                return;
            }
            boolean isSpecArgument = this.isSpecArgument(objectLiteral);
            TMethod ctor = this.containerTypesHelper.fromContext((EObject)objectLiteral).findConstructor((ContainerType)type);
            boolean _isSpecArgumentToSpecCtor = N4JSTypeValidator.isSpecArgumentToSpecCtor((Expression)objectLiteral, ctor);
            TypingStrategyFilter strategyFilter = new TypingStrategyFilter(typingStrategy, typingStrategy == TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS, _isSpecArgumentToSpecCtor);
            boolean _isSpecArgumentToSpecCtor_1 = N4JSTypeValidator.isSpecArgumentToSpecCtor((Expression)objectLiteral, ctor);
            TypingStrategyFilter strategyFilterIncludeNotAccessible = new TypingStrategyFilter(typingStrategy, typingStrategy == TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS, _isSpecArgumentToSpecCtor_1, true);
            Functions.Function1 _function = member -> strategyFilter.apply((TMember)member);
            Functions.Function1 _function_1 = member -> member.getName();
            Set expectedMembers = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.containerTypesHelper.fromContext((EObject)objectLiteral).allMembers((ContainerType)type), (Functions.Function1)_function), (Functions.Function1)_function_1));
            Functions.Function1 _function_2 = member -> strategyFilterIncludeNotAccessible.apply((TMember)member);
            Functions.Function1 _function_3 = member -> member.getName();
            Set expectedMembersPlusNotAccessibles = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.containerTypesHelper.fromContext((EObject)objectLiteral).allMembers((ContainerType)type), (Functions.Function1)_function_2), (Functions.Function1)_function_3));
            Consumer<TStructMember> _function_4 = member -> expectedMembers.add(member.getName());
            typeRef.getStructuralMembers().forEach(_function_4);
            ObjectLiteral container = objectLiteral;
            while (container instanceof ObjectLiteral || container instanceof ArrayLiteral || container instanceof ArrayElement) {
                container = container.eContainer();
            }
            String _switchResult = null;
            boolean _matched = false;
            if (container instanceof VariableDeclaration) {
                _matched = true;
                _switchResult = ((VariableDeclaration)container).getName();
            }
            if (!_matched && container instanceof AssignmentExpression) {
                _matched = true;
                String _xblockexpression = null;
                Expression lhs = ((AssignmentExpression)container).getLhs();
                String _switchResult_1 = null;
                boolean _matched_1 = false;
                if (lhs instanceof IdentifierRef) {
                    _matched_1 = true;
                    _switchResult_1 = ((IdentifierRef)lhs).getIdAsText();
                }
                if (!_matched_1 && lhs instanceof ParameterizedPropertyAccessExpression) {
                    _matched_1 = true;
                    _switchResult_1 = ((ParameterizedPropertyAccessExpression)lhs).getPropertyAsText();
                }
                if (!_matched_1) {
                    String _name = typeRef.getDeclaredType().getName();
                    _switchResult_1 = "references of type " + _name;
                }
                _switchResult = _xblockexpression = _switchResult_1;
            }
            if (!_matched && container instanceof Argument) {
                _matched = true;
                _switchResult = "the receiving parameter";
            }
            if (!_matched) {
                String _name = typeRef.getDeclaredType().getName();
                _switchResult = "references of type " + _name;
            }
            String lhsName = _switchResult;
            Type _definedType = objectLiteral.getDefinedType();
            EList inputMembers = ((ContainerType)_definedType).getOwnedMembers();
            for (TMember property : inputMembers) {
                boolean _not_1;
                boolean _not;
                boolean _contains = expectedMembers.contains(property.getName());
                boolean bl = _not = !_contains;
                if (!_not) continue;
                EObject astElement = property.getAstElement();
                if (astElement instanceof PropertyNameValuePair) {
                    astElement = ((PropertyNameValuePair)astElement).getDeclaredName();
                }
                if (isSpecArgument) {
                    String message = IssueCodes.getMessageForCLF_SPEC_SUPERFLUOUS_PROPERTIES(property.getName(), typeRef.getTypeRefAsString());
                    this.addIssue(message, astElement, "CLF_SPEC_SUPERFLUOUS_PROPERTIES");
                    continue;
                }
                boolean _contains_1 = expectedMembersPlusNotAccessibles.contains(property.getName());
                boolean bl2 = _not_1 = !_contains_1;
                if (!_not_1) continue;
                String message_1 = IssueCodes.getMessageForCLF_SUPERFLUOUS_PROPERTIES(property.getName(), typeRef.getTypeRefAsString(), lhsName);
                this.addIssue(message_1, astElement, "CLF_SUPERFLUOUS_PROPERTIES");
            }
        }
    }

    private boolean isSpecArgument(ObjectLiteral objectLiteral) {
        boolean usedInConstructor;
        EObject _eContainer = objectLiteral.eContainer();
        EObject _eContainer_1 = null;
        if (_eContainer != null) {
            _eContainer_1 = _eContainer.eContainer();
        }
        if (usedInConstructor = _eContainer_1 instanceof NewExpression) {
            NewExpression newExpression;
            TypeRef newTypeRef;
            Type newType;
            EObject _eContainer_2 = objectLiteral.eContainer();
            EObject _eContainer_3 = null;
            if (_eContainer_2 != null) {
                _eContainer_3 = _eContainer_2.eContainer();
            }
            if ((newType = (newTypeRef = this.ts.tau((TypableElement)(newExpression = (NewExpression)_eContainer_3))).getDeclaredType()) == null && newTypeRef instanceof BoundThisTypeRef) {
                ParameterizedTypeRef _actualThisTypeRef = ((BoundThisTypeRef)newTypeRef).getActualThisTypeRef();
                Type _declaredType = null;
                if (_actualThisTypeRef != null) {
                    _declaredType = _actualThisTypeRef.getDeclaredType();
                }
                newType = _declaredType;
            }
            if (newType instanceof ContainerType) {
                TMethod newCtor = this.containerTypesHelper.fromContext((EObject)newExpression).findConstructor((ContainerType)newType);
                int pos = newExpression.getArguments().indexOf((Object)objectLiteral.eContainer());
                if (newCtor != null && pos >= 0) {
                    TFormalParameter formalParam = newCtor.getFparForArgIdx(pos);
                    Functions.Function1 _function = an -> an.getName().equals("Spec");
                    boolean hasSpecAnnotation = IterableExtensions.exists((Iterable)formalParam.getAnnotations(), (Functions.Function1)_function);
                    return hasSpecAnnotation;
                }
            }
        }
        return false;
    }

    private void internalCheckUseOfUndefinedExpression(RuleEnvironment G, Expression expression, TypeRef expectedTypeRef, TypeRef actualTypeRef) {
        EObject parent;
        if (!(!TypeUtils.isUndefined((TypeArgument)actualTypeRef) || TypeUtils.isUndefined((TypeArgument)expectedTypeRef) || (parent = expression.eContainer()) instanceof ExpressionStatement || parent instanceof UnaryExpression && ((UnaryExpression)parent).getOp() == UnaryOperator.VOID || expression instanceof UnaryExpression && ((UnaryExpression)expression).getOp() == UnaryOperator.VOID || expression instanceof ThisLiteral)) {
            boolean isUndefinedLiteral;
            TMember _findOwnedMember = RuleEnvironmentExtensions.globalObjectType(G).findOwnedMember("undefined", false, false);
            TField undefinedField = (TField)_findOwnedMember;
            boolean _xifexpression = false;
            if (expression instanceof IdentifierRef) {
                IdentifiableElement _id = ((IdentifierRef)expression).getId();
                boolean bl = _xifexpression = _id == undefinedField;
            }
            if (!(isUndefinedLiteral = _xifexpression)) {
                this.addIssue(IssueCodes.getMessageForEXP_USE_OF_UNDEF_EXPR(), (EObject)expression, "EXP_USE_OF_UNDEF_EXPR");
            }
        }
    }

    @Check
    public void checkBogusTypeReference(TypedElement te) {
        boolean _tripleNotEquals;
        TypeRef _bogusTypeRef = te.getBogusTypeRef();
        boolean bl = _tripleNotEquals = _bogusTypeRef != null;
        if (_tripleNotEquals) {
            this.addIssue(IssueCodes.getMessageForTYS_INVALID_TYPE_SYNTAX(), (EObject)te.getBogusTypeRef(), "TYS_INVALID_TYPE_SYNTAX");
        }
    }

    @Check
    public void checkUnionTypeContainsNoAny(UnionTypeExpression ute) {
        this.checkComposedTypeRefContainsNoAny((ComposedTypeRef)ute, IssueCodes.getMessageForUNI_ANY_USED(), "UNI_ANY_USED", true);
    }

    @Check
    public void checkIntersectionTypeContainsNoAny(IntersectionTypeExpression ite) {
        this.checkComposedTypeRefContainsNoAny((ComposedTypeRef)ite, IssueCodes.getMessageForINTER_ANY_USED(), "INTER_ANY_USED", false);
    }

    private void checkComposedTypeRefContainsNoAny(ComposedTypeRef ctr, String msg, String issueCode, boolean soleVoidAllowesAny) {
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ctr);
        AnyType anyType = RuleEnvironmentExtensions.anyType(G);
        VoidType voidType = RuleEnvironmentExtensions.voidType(G);
        EList typeRefs = ctr.getTypeRefs();
        Functions.Function1 _function = it -> {
            Type _declaredType = it.getDeclaredType();
            return _declaredType == anyType;
        };
        Iterable anyTypeRefs = IterableExtensions.filter((Iterable)typeRefs, (Functions.Function1)_function);
        boolean dontShowWarning = false;
        if (soleVoidAllowesAny) {
            Functions.Function1 _function_1 = it -> {
                Type _declaredType = it.getDeclaredType();
                return _declaredType == voidType;
            };
            boolean containsVoid = IterableExtensions.exists((Iterable)typeRefs, (Functions.Function1)_function_1);
            boolean bl = dontShowWarning = containsVoid && IterableExtensions.size((Iterable)anyTypeRefs) == 1;
        }
        if (!dontShowWarning) {
            for (TypeRef anyTR : anyTypeRefs) {
                this.addIssue(msg, (EObject)anyTR, issueCode);
            }
        }
    }

    @Check
    public void checkUnionHasUnnecessarySubtype(UnionTypeExpression ute) {
        boolean _greaterThan;
        List<TypeRef> tRefs = this.extractNonStructTypeRefs((ComposedTypeRef)ute);
        RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ute);
        AnyType anyType = RuleEnvironmentExtensions.anyType(G);
        Predicate<TypeRef> _function = it -> {
            Type _declaredType = it.getDeclaredType();
            return _declaredType == anyType;
        };
        tRefs.removeIf(_function);
        int _size = tRefs.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            List<TypeRef> intersectionTR = this.tsh.getSuperTypesOnly(G, (TypeRef[])Conversions.unwrapArray(tRefs, TypeRef.class));
            tRefs.removeAll(intersectionTR);
            for (TypeRef tClassR : tRefs) {
                String message = IssueCodes.getMessageForUNI_REDUNDANT_SUBTYPE();
                this.addIssue(message, (EObject)tClassR, "UNI_REDUNDANT_SUBTYPE");
            }
        }
    }

    @Check
    public void checkIntersectionType(IntersectionTypeExpression ite) {
        boolean _greaterThan;
        List<TypeRef> tClassRefs = this.extractNonStructTypeRefs((ComposedTypeRef)ite);
        int _size = tClassRefs.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            RuleEnvironment G = RuleEnvironmentExtensions.newRuleEnvironment((EObject)ite);
            List<TypeRef> intersectionTR = this.tsh.getSubtypesOnly(G, (TypeRef[])Conversions.unwrapArray(tClassRefs, TypeRef.class));
            this.checkIntersectionTypeContainsMaxOneClass(G, intersectionTR, false);
            this.checkIntersectionHasUnnecessarySupertype(tClassRefs, intersectionTR);
        }
    }

    private void checkIntersectionTypeContainsMaxOneClass(RuleEnvironment G, List<TypeRef> intersectionTR, boolean covariantTypeArgValidation) {
        block7: {
            List ptrs;
            block9: {
                ArrayListMultimap byTypes;
                block8: {
                    boolean _greaterThan_1;
                    boolean _greaterThan;
                    int _size = intersectionTR.size();
                    boolean bl = _greaterThan = _size > 1;
                    if (!_greaterThan) break block7;
                    byTypes = ArrayListMultimap.create();
                    for (TypeRef tClassR : intersectionTR) {
                        byTypes.put((Object)tClassR.getDeclaredType(), (Object)tClassR);
                    }
                    int _size_1 = byTypes.keySet().size();
                    boolean bl2 = _greaterThan_1 = _size_1 > 1;
                    if (!_greaterThan_1) break block8;
                    if (covariantTypeArgValidation) {
                        String message = IssueCodes.getMessageForINTER_TYEPARGS_ONLY_ONE_CLASS_ALLOWED();
                        for (TypeRef tClassR_1 : intersectionTR) {
                            boolean _not;
                            EObject _eContainer = tClassR_1.eContainer();
                            boolean bl3 = _not = !(_eContainer instanceof TypeVariable);
                            if (!_not) continue;
                            this.addIssue(message, (EObject)tClassR_1, "INTER_TYEPARGS_ONLY_ONE_CLASS_ALLOWED");
                        }
                    } else {
                        String message_1 = IssueCodes.getMessageForINTER_ONLY_ONE_CLASS_ALLOWED();
                        for (TypeRef tClassR_2 : intersectionTR) {
                            this.addIssue(message_1, (EObject)tClassR_2, "INTER_ONLY_ONE_CLASS_ALLOWED");
                        }
                    }
                    break block7;
                }
                Type type = (Type)IterableExtensions.head((Iterable)byTypes.keys());
                boolean _isGeneric = type.isGeneric();
                if (!_isGeneric) break block7;
                ptrs = byTypes.get((Object)type);
                boolean _allCovariantOrWildcardWithUpperBound = this.allCovariantOrWildcardWithUpperBound((List<TypeVariable>)type.getTypeVars(), ptrs);
                if (!_allCovariantOrWildcardWithUpperBound) break block9;
                int length = ((Object[])Conversions.unwrapArray((Object)type.getTypeVars(), Object.class)).length;
                int v = 0;
                while (v < length) {
                    int vIndex = v++;
                    Functions.Function1 _function = ptr -> {
                        TypeArgument ta = (TypeArgument)ptr.getTypeArgs().get(vIndex);
                        TypeRef upper = null;
                        if (ta instanceof TypeRef) {
                            upper = (TypeRef)ta;
                        }
                        if (upper == null && ta instanceof Wildcard) {
                            upper = ((Wildcard)ta).getDeclaredUpperBound();
                        }
                        if (upper == null) {
                            upper = ((TypeVariable)type.getTypeVars().get(vIndex)).getDeclaredUpperBound();
                        }
                        return upper;
                    };
                    List<TypeRef> typeArgsPerVariable = this.extractNonStructTypeRefs(ListExtensions.map((List)ptrs, (Functions.Function1)_function));
                    this.checkIntersectionTypeContainsMaxOneClass(G, typeArgsPerVariable, true);
                }
                break block7;
            }
            Functions.Function1 _function = ptr -> {
                Functions.Function1 _function_1 = ta -> ta instanceof Wildcard && ((Wildcard)ta).getDeclaredLowerBound() != null;
                return IterableExtensions.forall((Iterable)ptr.getTypeArgs(), (Functions.Function1)_function_1);
            };
            boolean _forall = IterableExtensions.forall((Iterable)ptrs, (Functions.Function1)_function);
            if (_forall) break block7;
            String message_2 = IssueCodes.getMessageForINTER_WITH_ONE_GENERIC();
            for (TypeRef tClassR_3 : intersectionTR) {
                boolean _not_1;
                EObject _eContainer_1 = tClassR_3.eContainer();
                boolean bl = _not_1 = !(_eContainer_1 instanceof TypeVariable);
                if (!_not_1) continue;
                this.addIssue(message_2, (EObject)tClassR_3, "INTER_WITH_ONE_GENERIC");
            }
        }
    }

    private boolean allCovariantOrWildcardWithUpperBound(List<TypeVariable> typeVars, List<TypeRef> refs) throws IndexOutOfBoundsException {
        int length = ((Object[])Conversions.unwrapArray(typeVars, Object.class)).length;
        int i = 0;
        while (i < length) {
            boolean _not;
            boolean _isDeclaredCovariant = typeVars.get(i).isDeclaredCovariant();
            boolean bl = _not = !_isDeclaredCovariant;
            if (_not) {
                for (TypeRef ref : refs) {
                    TypeArgument ta = (TypeArgument)ref.getTypeArgs().get(i);
                    if (ta instanceof Wildcard) {
                        boolean _tripleEquals;
                        TypeRef _declaredUpperBound = ((Wildcard)ta).getDeclaredUpperBound();
                        boolean bl2 = _tripleEquals = _declaredUpperBound == null;
                        if (!_tripleEquals) continue;
                        return false;
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private void checkIntersectionHasUnnecessarySupertype(List<TypeRef> tClassRefs, List<TypeRef> intersectionTR) {
        tClassRefs.removeAll(intersectionTR);
        for (TypeRef tClassR : tClassRefs) {
            String message = IssueCodes.getMessageForINTER_REDUNDANT_SUPERTYPE();
            this.addIssue(message, (EObject)tClassR, "INTER_REDUNDANT_SUPERTYPE");
        }
    }

    private List<TypeRef> extractNonStructTypeRefs(ComposedTypeRef ctr) {
        Comparator _typeRefComparator = this.typeCompareHelper.getTypeRefComparator();
        TreeSet<TypeRef> typeRefs = new TreeSet<TypeRef>(_typeRefComparator);
        this.collectAndFlattenElementTypeRefs(ctr, typeRefs);
        return this.extractNonStructTypeRefs(typeRefs);
    }

    private void collectAndFlattenElementTypeRefs(ComposedTypeRef ctr, Collection<TypeRef> addHere) {
        EClass composedTypeKind = ctr.eClass();
        EList _typeRefs = ctr.getTypeRefs();
        for (TypeRef tr : _typeRefs) {
            boolean _isInstance = composedTypeKind.isInstance((Object)tr);
            if (_isInstance) {
                this.collectAndFlattenElementTypeRefs((ComposedTypeRef)tr, addHere);
                continue;
            }
            addHere.add(tr);
        }
    }

    private List<TypeRef> extractNonStructTypeRefs(Iterable<TypeRef> simplifiedTypeRefs) {
        LinkedList<TypeRef> tClassRefs = new LinkedList<TypeRef>();
        for (TypeRef tR : simplifiedTypeRefs) {
            boolean isStructural;
            Type type;
            if (tR == null || !((type = tR.getDeclaredType()) instanceof TClass)) continue;
            boolean bl = isStructural = tR.isDefSiteStructuralTyping() || tR.isUseSiteStructuralTyping();
            if (isStructural) continue;
            tClassRefs.add(tR);
        }
        return tClassRefs;
    }

    private static boolean isSpecArgumentToSpecCtor(Expression expr, TMethod ctor) {
        if (ctor == null) {
            return false;
        }
        EObject _eContainer = null;
        if (expr != null) {
            _eContainer = expr.eContainer();
        }
        EObject parent = _eContainer;
        EObject _eContainer_1 = null;
        if (parent != null) {
            _eContainer_1 = parent.eContainer();
        }
        EObject grandParent = _eContainer_1;
        if (parent instanceof Argument && grandParent instanceof NewExpression) {
            Argument arg = (Argument)parent;
            int argIdx = ((NewExpression)grandParent).getArguments().indexOf((Object)arg);
            TFormalParameter ctorFpar = ctor.getFparForArgIdx(argIdx);
            if (ctorFpar != null) {
                return AnnotationDefinition.SPEC.hasAnnotation((TAnnotableElement)ctorFpar);
            }
        }
        return false;
    }
}

