/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.util.NameStaticPair;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.validation.validators.utils.MemberMatrix;

public class MemberCube {
    private final Map<NameStaticPair, MemberMatrix> memberMatrixesByName = new HashMap<NameStaticPair, MemberMatrix>();

    public MemberCube(TClassifier tClassifier, ContainerTypesHelper.MemberCollector memberCollector) {
        this.addMembers(0, (List<TMember>)tClassifier.getOwnedMembers());
        if (tClassifier instanceof TClass) {
            this.addMembers(1, (List<TMember>)memberCollector.inheritedMembers((TClass)tClassifier));
        }
        this.addMembers(2, (List<TMember>)memberCollector.membersOfImplementedInterfacesForConsumption(tClassifier));
    }

    private void addMembers(int source, List<TMember> members) {
        for (TMember member : members) {
            NameStaticPair nsp = NameStaticPair.of((TMember)member);
            MemberMatrix memberMatrix = this.memberMatrixesByName.get(nsp);
            if (memberMatrix == null) {
                memberMatrix = new MemberMatrix();
                this.memberMatrixesByName.put(nsp, memberMatrix);
            }
            memberMatrix.add(source, member);
        }
    }

    public Set<Map.Entry<NameStaticPair, MemberMatrix>> entrySet() {
        return this.memberMatrixesByName.entrySet();
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        StringBuilder row = new StringBuilder();
        for (Map.Entry<NameStaticPair, MemberMatrix> entry : this.entrySet()) {
            row.setLength(0);
            row.append(entry.getKey().toString()).append(": ");
            UtilN4.fill((StringBuilder)row, (int)36);
            strb.append((CharSequence)row);
            strb.append(entry.getValue().toShortString()).append('\n');
        }
        return strb.toString();
    }
}

