/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.nodejs;

import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;
import org.eclipse.n4js.tester.ITester;
import org.eclipse.n4js.tester.TestConfiguration;
import org.eclipse.n4js.tester.extension.ITesterDescriptor;
import org.eclipse.n4js.tester.extension.TesterDescriptorImpl;

public class NodeTester
implements ITester {
    public static final String ID = "org.eclipse.n4js.tester.nodejs.NODEJS_MANGELHAFT";

    public TestConfiguration createConfiguration() {
        return new TestConfiguration();
    }

    public void prepareConfiguration(TestConfiguration config) {
    }

    public String getRunnerIdForTesting() {
        return "org.eclipse.n4js.runner.nodejs.NODEJS";
    }

    public Process test(TestConfiguration config, IExecutor executor, RunnerFrontEnd runnerFrontEnd) throws ExecutionException {
        Path testCatalog = this.createTestCatalog(config);
        Path fileToRun = this.findMangelhaftCliEntryPoint(config);
        config.setFileToRun(fileToRun);
        config.setRunOptions("--testCatalog " + testCatalog.toAbsolutePath() + " --quiet");
        return runnerFrontEnd.run((RunConfiguration)config, executor);
    }

    private Path createTestCatalog(TestConfiguration config) {
        try {
            Path testCatalog = Files.createTempFile("n4js-testCatalog-", "", new FileAttribute[0]);
            testCatalog.toFile().deleteOnExit();
            String testTreeAsJSON = config.getTestTreeAsJSON();
            Files.write(testCatalog, Collections.singletonList(testTreeAsJSON), Charsets.UTF_8, new OpenOption[0]);
            return testCatalog;
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to write test catalog to temporary file", e);
        }
    }

    private Path findMangelhaftCliEntryPoint(TestConfiguration config) {
        Path workingDirectory = config.getWorkingDirectory();
        if (workingDirectory == null) {
            throw new IllegalArgumentException("test configuration does not specify a working directory");
        }
        Path base = workingDirectory;
        while (base != null && !Files.isDirectory(base.resolve("node_modules").resolve(N4JSGlobals.MANGELHAFT_CLI.getRawName()), new LinkOption[0])) {
            base = base.getParent();
        }
        if (base == null) {
            throw new IllegalStateException("unable to find npm package '" + N4JSGlobals.MANGELHAFT_CLI + "'");
        }
        return base.resolve("node_modules").resolve(N4JSGlobals.MANGELHAFT_CLI.getRawName()).resolve("bin/n4js-mangelhaft-cli.js");
    }

    public static final class NodeTesterDescriptorProvider
    implements Provider<ITesterDescriptor> {
        @Inject
        private Provider<NodeTester> nodeTesterProvider;

        public ITesterDescriptor get() {
            return new TesterDescriptorImpl(NodeTester.ID, "Node.js Tester", RuntimeEnvironment.NODEJS_MANGELHAFT, (ITester)this.nodeTesterProvider.get());
        }
    }
}

