/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class RemoveFromIndexOperation
implements IEGitOperation {
    private final Map<Repository, Collection<String>> pathsByRepository;

    public RemoveFromIndexOperation(Collection<IPath> paths) {
        this.pathsByRepository = ResourceUtil.splitPathsByRepository(paths);
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        IProgressMonitor monitor = m != null ? m : new NullProgressMonitor();
        monitor.beginTask(CoreText.RemoveFromIndexOperation_removingFilesFromIndex, this.pathsByRepository.size());
        for (Map.Entry<Repository, Collection<String>> entry : this.pathsByRepository.entrySet()) {
            Repository repository = entry.getKey();
            Collection<String> paths = entry.getValue();
            GitCommand<?> command = RemoveFromIndexOperation.prepareCommand(repository, paths);
            try {
                command.call();
                monitor.worked(1);
            }
            catch (GitAPIException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        monitor.done();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.pathsByRepository.keySet());
    }

    private static GitCommand<?> prepareCommand(Repository repository, Collection<String> paths) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Git git = new Git(repository);){
            if (RemoveFromIndexOperation.hasHead(repository)) {
                ResetCommand resetCommand = git.reset();
                resetCommand.setRef("HEAD");
                for (String path : paths) {
                    resetCommand.addPath(RemoveFromIndexOperation.getCommandPath(path));
                }
                return resetCommand;
            }
            RmCommand rmCommand = git.rm();
            rmCommand.setCached(true);
            for (String path : paths) {
                rmCommand.addFilepattern(RemoveFromIndexOperation.getCommandPath(path));
            }
            return rmCommand;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean hasHead(Repository repository) {
        try {
            Ref head = repository.exactRef("HEAD");
            return head != null && head.getObjectId() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static String getCommandPath(String path) {
        if ("".equals(path)) {
            return ".";
        }
        return path;
    }
}

