/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist.imports;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.Range;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class ImportUtil {
    @Inject
    IdeContentProposalProvider contentProposalProvider;
    @Inject
    ContentAssistContextFactory cacFactory;
    @Inject
    ExecutorService executorService;

    public Set<ContentAssistEntry> findImportCandidates(ICodeActionService2.Options options) {
        Document doc = options.getDocument();
        String documentContent = doc.getContents();
        Range range = options.getCodeActionParams().getRange();
        String importIdentifier = doc.getSubstring(range);
        int offsetStart = doc.getOffSet(range.getStart());
        int offsetEnd = doc.getOffSet(range.getEnd());
        TextRegion textRegion = new TextRegion(offsetStart, offsetEnd - offsetStart);
        XtextResource resource = options.getResource();
        this.cacFactory.setPool(this.executorService);
        ContentAssistContext[] cacs = this.cacFactory.create(documentContent, (ITextRegion)textRegion, offsetEnd, resource);
        List<ContentAssistContext> contexts = Arrays.asList(cacs);
        ContentProposalAcceptorCollector acceptor = new ContentProposalAcceptorCollector();
        this.contentProposalProvider.createProposals(contexts, (IIdeContentProposalAcceptor)acceptor);
        LinkedHashSet<ContentAssistEntry> caEntries = new LinkedHashSet<ContentAssistEntry>();
        for (ContentAssistEntry caEntry : acceptor.caEntries) {
            if (!Objects.equal((Object)importIdentifier, (Object)caEntry.getProposal())) continue;
            caEntries.add(caEntry);
        }
        return caEntries;
    }

    class ContentProposalAcceptorCollector
    implements IIdeContentProposalAcceptor {
        final List<ContentAssistEntry> caEntries = new ArrayList<ContentAssistEntry>();

        ContentProposalAcceptorCollector() {
        }

        public void accept(ContentAssistEntry entry, int priority) {
            if (entry != null) {
                this.caEntries.add(entry);
            }
        }

        public boolean canAcceptMoreProposals() {
            return true;
        }
    }
}

