/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import java.util.concurrent.Callable;
import org.eclipse.n4js.flowgraphs.FlowAnalyser;
import org.eclipse.n4js.flowgraphs.N4JSFlowAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.DeadCodeAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.InstanceofGuardAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.MissingReturnOrThrowAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.NullDereferenceAnalyser;
import org.eclipse.n4js.flowgraphs.analysers.UsedBeforeDeclaredAnalyser;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;

public class ASTFlowInfo {
    public final DeadCodeAnalyser deadCodeAnalyser;
    public final InstanceofGuardAnalyser instanceofGuardAnalyser;
    public final UsedBeforeDeclaredAnalyser usedBeforeDeclaredAnalyser;
    public final NullDereferenceAnalyser nullDereferenceAnalyser;
    public final MissingReturnOrThrowAnalyser missingReturnOrThrowAnalyser;
    public final FlowAnalyser[] allAnalysers;
    private final N4JSFlowAnalyser flowAnalyzer = new N4JSFlowAnalyser();

    public ASTFlowInfo(TypeSystemHelper typeSystemHelper, JavaScriptVariantHelper jsVariantHelper) {
        this.deadCodeAnalyser = new DeadCodeAnalyser();
        this.instanceofGuardAnalyser = new InstanceofGuardAnalyser();
        this.usedBeforeDeclaredAnalyser = new UsedBeforeDeclaredAnalyser();
        this.nullDereferenceAnalyser = new NullDereferenceAnalyser();
        this.missingReturnOrThrowAnalyser = new MissingReturnOrThrowAnalyser(typeSystemHelper, jsVariantHelper);
        this.allAnalysers = new FlowAnalyser[]{this.deadCodeAnalyser, this.instanceofGuardAnalyser, this.usedBeforeDeclaredAnalyser, this.nullDereferenceAnalyser, this.missingReturnOrThrowAnalyser};
    }

    public void createGraphs(Script script, Callable<?> cancelledChecker) {
        this.flowAnalyzer.createGraphs(script, cancelledChecker);
    }

    public void performForwardAnalysis(Callable<?> cancelledChecker) {
        this.flowAnalyzer.acceptForwardAnalysers(cancelledChecker, this.allAnalysers);
    }

    public boolean canPerformBackwardAnalysis() {
        return N4JSFlowAnalyser.State.forwardsAnalyzed == this.flowAnalyzer.getState();
    }

    public void performBackwardAnalysis(Callable<?> cancelledChecker) {
        this.flowAnalyzer.acceptBackwardAnalysers(cancelledChecker, this.allAnalysers);
    }

    public void reset() {
        this.flowAnalyzer.reset();
        FlowAnalyser[] flowAnalyserArray = this.allAnalysers;
        int n = this.allAnalysers.length;
        int n2 = 0;
        while (n2 < n) {
            FlowAnalyser analyzer = flowAnalyserArray[n2];
            analyzer.clean();
            ++n2;
        }
    }
}

