/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.EffectType;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.NumericLiteral;

public class DivisionByZeroAnalyser
extends DataFlowVisitor {
    @Override
    public void visitEffect(EffectInfo effect, ControlFlowElement cfe) {
        if (this.isDivisor(effect.symbol, cfe)) {
            IsNotZero symbolNotZero = new IsNotZero(cfe, effect.symbol);
            this.assume(symbolNotZero);
        }
    }

    boolean isDivisor(Symbol symbol, ControlFlowElement cfe) {
        MultiplicativeExpression me;
        return cfe instanceof MultiplicativeExpression && symbol.is((me = (MultiplicativeExpression)cfe).getLhs());
    }

    private static boolean isZeroLiteral(Expression expr) {
        if (expr instanceof NumericLiteral) {
            NumericLiteral numLit = (NumericLiteral)expr;
            BigDecimal litValue = numLit.getValue();
            return litValue.equals(BigDecimal.ZERO);
        }
        return false;
    }

    static class IsNotZero
    extends Assumption {
        IsNotZero(ControlFlowElement cfe, Symbol symbol) {
            super(cfe, symbol);
        }

        IsNotZero(IsNotZero copy) {
            super(copy);
        }

        @Override
        public Assumption copy() {
            return new IsNotZero(this);
        }

        @Override
        public PartialResult holdsOnEffect(EffectInfo effect, ControlFlowElement cfe) {
            AssignmentExpression ae;
            Expression rhs;
            if (effect.type == EffectType.Write && cfe instanceof AssignmentExpression && DivisionByZeroAnalyser.isZeroLiteral(rhs = (ae = (AssignmentExpression)cfe).getRhs())) {
                return PartialResult.Passed;
            }
            return PartialResult.Unclear;
        }

        @Override
        public PartialResult holdsOnGuards(Multimap<GuardType, Guard> neverHolding, Multimap<GuardType, Guard> alwaysHolding) {
            alwaysHolding.containsKey((Object)GuardType.IsZero);
            if (neverHolding.containsKey((Object)GuardType.IsZero)) {
                return PartialResult.Passed;
            }
            return PartialResult.Unclear;
        }
    }
}

