/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Singleton;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.lsp4j.Location;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.xtext.ide.server.DocumentExtensions;
import org.eclipse.xtext.util.ITextRegion;

@Singleton
public class N4JSDocumentExtensions
extends DocumentExtensions {
    public Location newLocation(Resource resource, ITextRegion textRegion) {
        Location result = super.newLocation(resource, textRegion);
        if (result != null && N4Scheme.isResourceWithN4Scheme((Resource)resource)) {
            URI uri = resource.getURI();
            URIConverter uriConverter = resource.getResourceSet().getURIConverter();
            URI classpathURI = N4Scheme.toClasspathURI((URI)uri);
            URI resolvedURI = uriConverter.normalize(classpathURI);
            return new Location(resolvedURI.toString(), result.getRange());
        }
        return result;
    }
}

