/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.ide.editor.contentassist.imports.ImportUtil;
import org.eclipse.n4js.ide.server.codeActions.CodeActionAcceptor;
import org.eclipse.n4js.ide.server.codeActions.Fix;
import org.eclipse.n4js.ide.server.codeActions.IQuickfixProvider;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.util.ReplaceRegion;

@Singleton
public class N4JSQuickfixProvider
implements IQuickfixProvider {
    final Class<?>[] quickfixProviders = new Class[]{N4JSQuickfixProvider.class};
    Map<String, BiConsumer<QuickfixContext, CodeActionAcceptor>> quickfixMap = new HashMap<String, BiConsumer<QuickfixContext, CodeActionAcceptor>>();
    @Inject
    private ImportUtil importUtil;
    static final String INTERNAL_ANNOTATION = AnnotationDefinition.INTERNAL.name;
    static final String OVERRIDE_ANNOTATION = AnnotationDefinition.OVERRIDE.name;
    static final String FINAL_ANNOTATION = AnnotationDefinition.FINAL.name;

    @Inject
    public void init(Injector injector) {
        Class<?>[] classArray = this.quickfixProviders;
        int n = this.quickfixProviders.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> potQP = classArray[n2];
            if (IQuickfixProvider.class.isAssignableFrom(potQP)) {
                Method[] methods;
                final IQuickfixProvider qpInstance = (IQuickfixProvider)injector.getInstance(potQP);
                Method[] methodArray = methods = potQP.getMethods();
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    final Method method = methodArray[n4];
                    Fix fixAnnotation = method.getAnnotation(Fix.class);
                    if (fixAnnotation != null) {
                        String issueCode = fixAnnotation.issueCode();
                        BiConsumer<QuickfixContext, CodeActionAcceptor> quickfixMethod = new BiConsumer<QuickfixContext, CodeActionAcceptor>(){

                            @Override
                            public void accept(QuickfixContext qc, CodeActionAcceptor caa) {
                                try {
                                    method.invoke((Object)qpInstance, qc, caa);
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                                catch (IllegalArgumentException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                            }
                        };
                        this.quickfixMap.put(issueCode, quickfixMethod);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void addQuickfix(String code, ICodeActionService2.Options options, CodeActionAcceptor acceptor) {
        BiConsumer<QuickfixContext, CodeActionAcceptor> quickfix = this.quickfixMap.get(code);
        if (quickfix != null) {
            QuickfixContext qc = new QuickfixContext(code, options);
            quickfix.accept(qc, acceptor);
        }
    }

    @Fix(issueCode="org.eclipse.xtext.diagnostics.Diagnostic.Linking")
    public void addImportForUnresolvedReference(QuickfixContext context, CodeActionAcceptor acceptor) {
        Document doc = context.options.getDocument();
        Set<ContentAssistEntry> caEntries = this.importUtil.findImportCandidates(context.options);
        for (ContentAssistEntry cae : caEntries) {
            ArrayList replacements = cae.getTextReplacements();
            if (replacements == null || replacements.isEmpty()) continue;
            String description = cae.getDescription();
            ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
            for (ReplaceRegion replaceRegion : replacements) {
                Position posStart = doc.getPosition(replaceRegion.getOffset());
                Position posEnd = doc.getPosition(replaceRegion.getOffset() + replaceRegion.getLength());
                Range rangeOfImport = new Range(posStart, posEnd);
                TextEdit textEdit = new TextEdit(rangeOfImport, replaceRegion.getText());
                textEdits.add(textEdit);
            }
            acceptor.acceptQuickfixCodeAction(context, "Add import from module " + description, textEdits);
        }
    }

    class QuickfixContext {
        final String code;
        final ICodeActionService2.Options options;

        public QuickfixContext(String code, ICodeActionService2.Options options) {
            this.code = code;
            this.options = options;
        }
    }
}

