/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class FileCopy
extends AbstractWorkflowComponent {
    private String sourceFile = null;
    private String targetFile = null;

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setTargetFile(String targetFile) {
        this.targetFile = targetFile;
    }

    public void checkConfiguration(Issues issues) {
        if (this.sourceFile == null) {
            issues.addError("No sourceFile set.");
        }
        if (this.targetFile == null) {
            issues.addError("No targetFile set.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        try {
            File source = new File(this.sourceFile);
            File target = new File(this.targetFile);
            if (!source.exists()) {
                issues.addWarning((WorkflowComponent)this, "Source file " + this.sourceFile + " does not exist. Skipping.");
                return;
            }
            if (!target.exists()) {
                target.createNewFile();
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(source);
                try {
                    block28: {
                        FileOutputStream fileOutputStream = new FileOutputStream(target);
                        try {
                            block27: {
                                FileChannel sourceChannel = fileInputStream.getChannel();
                                try {
                                    try (FileChannel destinationChannel = fileOutputStream.getChannel();){
                                        destinationChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
                                    }
                                    if (sourceChannel == null) break block27;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (sourceChannel == null) throw throwable;
                                    sourceChannel.close();
                                    throw throwable;
                                }
                                sourceChannel.close();
                            }
                            if (fileOutputStream == null) break block28;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fileOutputStream == null) throw throwable;
                            fileOutputStream.close();
                            throw throwable;
                        }
                        fileOutputStream.close();
                    }
                    if (fileInputStream == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (fileInputStream == null) throw throwable;
                    fileInputStream.close();
                    throw throwable;
                }
                fileInputStream.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException x) {
            issues.addError((WorkflowComponent)this, "Cannot perform I/O.", (Object)x);
        }
    }
}

