/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.utils.Log;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

@Log
public class RepoRelativePath {
    private static final Logger LOGGER = Logger.getLogger(RepoRelativePath.class);
    public final String repositoryName;
    public final String pathOfProjectInRepo;
    public final N4JSProjectName projectName;
    public final String pathInProject;
    public final int lineNumber;

    public static RepoRelativePath compute(FileURI uriOfResource, IN4JSCore n4jsCore) {
        File absolutePathOfResource;
        Optional optProj = n4jsCore.findProject(uriOfResource.toURI());
        if (!optProj.isPresent()) {
            return null;
        }
        IN4JSProject project = (IN4JSProject)optProj.get();
        Path pathOfResource = uriOfResource.toFileSystemPath();
        Path pathOfProject = project.getLocation().toFileSystemPath();
        String fileOfResourceInsideProject = pathOfProject.relativize(pathOfResource).toString();
        int anchorIndex = fileOfResourceInsideProject.indexOf("#");
        if (anchorIndex >= 0) {
            fileOfResourceInsideProject = fileOfResourceInsideProject.substring(0, anchorIndex);
        }
        if (!(absolutePathOfResource = pathOfProject.toAbsolutePath().resolve(fileOfResourceInsideProject).toFile()).exists()) {
            return null;
        }
        File repoFolder = RepoRelativePath.getRepoFolder(absolutePathOfResource);
        String pathOfProjectInRepo = RepoRelativePath.getRepoPath(repoFolder, pathOfProject.getParent().toFile());
        if (pathOfProjectInRepo == null) {
            return null;
        }
        String pathOfResourceInProject = String.valueOf('/') + fileOfResourceInsideProject;
        if (File.separatorChar != '/') {
            pathOfResourceInProject = pathOfResourceInProject.replace(File.separatorChar, '/');
            pathOfProjectInRepo = pathOfProjectInRepo.replace(File.separatorChar, '/');
        }
        N4JSProjectName projName = project.getProjectName();
        String repoName = RepoRelativePath.getRepoName(repoFolder);
        return new RepoRelativePath(repoName, pathOfProjectInRepo, projName, pathOfResourceInProject, -1);
    }

    private static File getRepoFolder(File file) {
        File currentFolder = file.getParentFile();
        while (currentFolder != null && currentFolder.isDirectory() && currentFolder.exists()) {
            String repoName = RepoRelativePath.getRepoName(currentFolder);
            if (!Strings.isNullOrEmpty((String)repoName)) {
                return currentFolder;
            }
            currentFolder = currentFolder.getParentFile();
        }
        return currentFolder;
    }

    private static String getRepoName(File currentDir) {
        if (currentDir == null) {
            return "NO_REPO";
        }
        File gitFolder = new File(currentDir, ".git");
        if (!gitFolder.isDirectory()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("No '.git' folder at " + currentDir.getAbsolutePath()));
            }
            return null;
        }
        File config = new File(gitFolder, "config");
        if (!config.isFile()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("No 'config' file at " + gitFolder.getAbsolutePath()));
            }
            return null;
        }
        try {
            String configStr = Files.asCharSource((File)config, (Charset)Charset.defaultCharset()).read();
            Config cfg = new Config();
            cfg.fromText(configStr);
            String originURL = cfg.getString("remote", "origin", "url");
            if (originURL != null && !originURL.isEmpty()) {
                int lastSlash = originURL.lastIndexOf(47);
                String repoName = null;
                repoName = lastSlash >= 0 ? originURL.substring(lastSlash + 1) : originURL;
                if (repoName.endsWith(".git")) {
                    repoName = repoName.substring(0, repoName.length() - 4);
                }
                return repoName;
            }
        }
        catch (IOException | ConfigInvalidException e) {
            LOGGER.warn((Object)("Cannot read git config at " + config.getAbsolutePath()), e);
        }
        return null;
    }

    private static String getRepoPath(File repoFolder, File fileInsideRepo) {
        String repoFolderAbs = repoFolder.getAbsolutePath();
        String fileInsideRepoAbs = fileInsideRepo.getAbsolutePath();
        if (fileInsideRepoAbs.startsWith(repoFolderAbs)) {
            return fileInsideRepoAbs.substring(repoFolderAbs.length());
        }
        return null;
    }

    private RepoRelativePath(String repositoryName, String pathOfProjectInRepo, N4JSProjectName projectName, String pathOfResourceInProject, int lineNumber) {
        this.repositoryName = repositoryName;
        this.pathOfProjectInRepo = pathOfProjectInRepo;
        this.projectName = projectName;
        this.pathInProject = pathOfResourceInProject;
        this.lineNumber = lineNumber;
    }

    public RepoRelativePath withLine(SyntaxRelatedTElement testMember) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)testMember.getAstElement());
        if (node != null) {
            int line = node.getStartLine();
            RepoRelativePath rrp = new RepoRelativePath(this.repositoryName, this.pathOfProjectInRepo, this.projectName, this.pathInProject, line);
            return rrp;
        }
        return this;
    }

    public int compareTo(RepoRelativePath rrp) {
        if (rrp == this) {
            return 0;
        }
        if (rrp == null) {
            return 1;
        }
        int d = this.repositoryName.compareTo(rrp.repositoryName);
        if (d != 0) {
            return d;
        }
        d = this.pathOfProjectInRepo.compareTo(rrp.pathOfProjectInRepo);
        if (d != 0) {
            return d;
        }
        d = this.projectName.compareTo(rrp.projectName);
        if (d != 0) {
            return d;
        }
        d = this.pathInProject.compareTo(rrp.pathInProject);
        if (d != 0) {
            return d;
        }
        d = this.lineNumber - rrp.lineNumber;
        return d;
    }

    public int hashCode() {
        int hash = this.repositoryName.hashCode() * 31;
        hash += (hash + this.pathOfProjectInRepo.hashCode()) * 31;
        hash += (hash + this.projectName.hashCode()) * 31;
        hash += (hash + this.pathInProject.hashCode()) * 31;
        return hash + this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RepoRelativePath) {
            return this.compareTo((RepoRelativePath)obj) == 0;
        }
        return false;
    }

    public String getFullPath() {
        return String.valueOf(this.repositoryName) + this.pathOfProjectInRepo + this.projectName + this.pathInProject;
    }

    public String toString() {
        return "repo: " + this.repositoryName + ", pir: " + this.pathOfProjectInRepo + ", proj: " + this.projectName + ", pip: " + this.pathInProject + ":" + this.lineNumber;
    }
}

