/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowBranchWalker;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitorHost;

class DataFlowGraphExplorer
extends GraphExplorerInternal {
    protected final DataFlowVisitorHost dataFlowVisitorHost;

    public DataFlowGraphExplorer(DataFlowVisitorHost dataFlowVisitorHost) {
        this.dataFlowVisitorHost = dataFlowVisitorHost;
    }

    @Override
    protected BranchWalkerInternal firstBranchWalker() {
        return new DataFlowBranchWalker();
    }

    @Override
    protected BranchWalkerInternal joinBranchWalkers(List<BranchWalkerInternal> branchWalkers) {
        DataFlowBranchWalker mergedDFB = new DataFlowBranchWalker();
        for (BranchWalkerInternal bwi : branchWalkers) {
            DataFlowBranchWalker dfb = (DataFlowBranchWalker)bwi;
            Iterator<Map.Entry<Object, Assumption>> entryIter = dfb.assumptions.entrySet().iterator();
            while (entryIter.hasNext()) {
                Map.Entry<Object, Assumption> entry = entryIter.next();
                Object key = entry.getKey();
                if (mergedDFB.assumptions.containsKey(key)) {
                    Assumption ass = mergedDFB.assumptions.get(key);
                    ass.mergeWith(entry.getValue());
                } else {
                    mergedDFB.assumptions.put(key, entry.getValue());
                }
                entryIter.remove();
            }
        }
        Iterator<Assumption> assIter = mergedDFB.assumptions.values().iterator();
        while (assIter.hasNext()) {
            Assumption ass = assIter.next();
            ass.checkAndFinalize();
            if (!ass.isDone()) continue;
            assIter.remove();
        }
        return mergedDFB;
    }
}

