/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.DestructNode;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.EqualityOperator;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PropertyAssignment;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationContainer;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableEnvironmentElement;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.n4JS.WithStatement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.es.transform.StaticPolyfillTransformation;
import org.eclipse.n4js.transpiler.im.IdentifierRef_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryIMOnly;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@TransformationDependency.Optional(value={GeneratorOption.Destructuring})
@TransformationDependency.ExcludesAfter(value={StaticPolyfillTransformation.class})
public class DestructuringTransformation
extends Transformation {
    private final Map<VariableEnvironmentElement, Integer> destructsPerScope = CollectionLiterals.newHashMap();

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Functions.Function1 _function = it -> DestructureUtils.containsDestructuringPattern((VariableDeclarationContainer)it);
        List destructBindings = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)this.collectNodes((EObject)this.getState().im, VariableStatement.class, true), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> DestructureUtils.isTopOfDestructuringAssignment((EObject)it);
        Functions.Function1 _function_2 = it -> DestructureUtils.isRoot((EObject)it);
        List destructAssignments = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter((Iterable)this.collectNodes((EObject)this.getState().im, AssignmentExpression.class, true), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> DestructureUtils.containsDestructuringPattern((VariableDeclarationContainer)it) || DestructureUtils.isTopOfDestructuringForStatement((EObject)it);
        List destructForStmnts = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)this.collectNodes((EObject)this.getState().im, ForStatement.class, true), (Functions.Function1)_function_3));
        Consumer<VariableStatement> _function_4 = it -> this.transformDestructuringBindings((VariableStatement)it);
        destructBindings.forEach(_function_4);
        Consumer<AssignmentExpression> _function_5 = it -> this.transformDestructuringAssignment((AssignmentExpression)it);
        destructAssignments.forEach(_function_5);
        Consumer<ForStatement> _function_6 = it -> this.transformForStatementWithDestructuring((ForStatement)it);
        destructForStmnts.forEach(_function_6);
    }

    private void transformDestructuringBindings(VariableStatement stmnt) {
        List<VariableDeclaration> newVarDecls = this.computeVariableDeclarations((List<VariableDeclarationOrBinding>)stmnt.getVarDeclsOrBindings());
        stmnt.getVarDeclsOrBindings().clear();
        EList _varDeclsOrBindings = stmnt.getVarDeclsOrBindings();
        Iterables.addAll((Collection)_varDeclsOrBindings, newVarDecls);
    }

    public void transformDestructuringAssignment(AssignmentExpression expr) {
        String fparName = null;
        FunctionExpression helperFun = null;
        fparName = "$destructParam0";
        FormalParameter fpar = TranspilerBuilderBlocks._FormalParameter((String)fparName);
        helperFun = TranspilerBuilderBlocks._FunExpr((boolean)false, null, (FormalParameter[])new FormalParameter[]{fpar});
        EList helperFunContents = helperFun.getBody().getStatements();
        DestructNode rootNode = DestructNode.unify((AssignmentExpression)expr);
        ArrayList helperVars = CollectionLiterals.newArrayList();
        ArrayList simpleAssignments = CollectionLiterals.newArrayList();
        this.traverse(helperVars, simpleAssignments, rootNode, expr.getRhs(), fparName);
        Functions.Function1 _function = it -> TranspilerBuilderBlocks._VariableStatement((VariableDeclaration[])new VariableDeclaration[]{it});
        List _map = ListExtensions.map((List)helperVars, (Functions.Function1)_function);
        Iterables.addAll((Collection)helperFunContents, (Iterable)_map);
        Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)this.__NSSafe_IdentRef((SymbolTableEntry)it.getKey()), (Expression)((Expression)it.getValue())));
        List _map_1 = ListExtensions.map((List)simpleAssignments, (Functions.Function1)_function_1);
        Iterables.addAll((Collection)helperFunContents, (Iterable)_map_1);
        SymbolTableEntry firstHelperVarSTE = this.findSymbolTableEntryForElement((NamedElement)helperVars.get(0), false);
        ReturnStatement __ReturnStmnt = TranspilerBuilderBlocks._ReturnStmnt((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)firstHelperVarSTE));
        helperFunContents.add((Object)__ReturnStmnt);
        ParameterizedCallExpression callExpr = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._Parenthesis((Expression)helperFun), (Expression[])new Expression[]{expr.getRhs()});
        this.replace((Expression)expr, (Expression)callExpr);
    }

    private void transformForStatementWithDestructuring(ForStatement stmnt) {
        boolean _isForPlain = stmnt.isForPlain();
        if (_isForPlain) {
            boolean _not;
            boolean _isEmpty = stmnt.getVarDeclsOrBindings().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                List<VariableDeclaration> newVarDecls = this.computeVariableDeclarations((List<VariableDeclarationOrBinding>)stmnt.getVarDeclsOrBindings());
                stmnt.getVarDeclsOrBindings().clear();
                EList _varDeclsOrBindings = stmnt.getVarDeclsOrBindings();
                Iterables.addAll((Collection)_varDeclsOrBindings, newVarDecls);
            }
        } else {
            boolean _not_2;
            boolean _not_1;
            int depth = DestructuringTransformation.getNestingDepth(stmnt);
            VariableDeclaration iterVar = TranspilerBuilderBlocks._VariableDeclaration((String)("$destructStep$" + Integer.valueOf(depth)));
            SymbolTableEntryIMOnly iterVarSTE = this.createSymbolTableEntryIMOnly((NamedElement)iterVar);
            boolean needDeclarations = false;
            VariableStatementKeyword varStmtKeyword = VariableStatementKeyword.VAR;
            ArrayList helperVars = CollectionLiterals.newArrayList();
            ArrayList simpleAssignments = CollectionLiterals.newArrayList();
            boolean _isEmpty_1 = stmnt.getVarDeclsOrBindings().isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                VariableDeclarationOrBinding _head = (VariableDeclarationOrBinding)IterableExtensions.head((Iterable)stmnt.getVarDeclsOrBindings());
                DestructNode rootNode = DestructNode.unify((VariableBinding)((VariableBinding)_head));
                this.traverse(helperVars, simpleAssignments, rootNode, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)iterVarSTE), null);
                needDeclarations = true;
                varStmtKeyword = stmnt.getVarStmtKeyword();
            } else if (stmnt.getInitExpr() instanceof ArrayLiteral || stmnt.getInitExpr() instanceof ObjectLiteral) {
                DestructNode rootNode_1 = DestructNode.unify((ForStatement)stmnt);
                this.traverse(helperVars, simpleAssignments, rootNode_1, (Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)iterVarSTE), null);
                needDeclarations = false;
            } else {
                throw new IllegalArgumentException();
            }
            Statement _statement = stmnt.getStatement();
            boolean bl2 = _not_2 = !(_statement instanceof Block);
            if (_not_2) {
                stmnt.setStatement((Statement)TranspilerBuilderBlocks._Block((Statement[])new Statement[]{stmnt.getStatement()}));
            }
            Statement _statement_1 = stmnt.getStatement();
            Block body = (Block)_statement_1;
            ArrayList toBeInserted = CollectionLiterals.newArrayList();
            if (needDeclarations) {
                Functions.Function1 _function = it -> {
                    VariableDeclaration varDecl = DestructuringTransformation.getVariableDeclarationFromSTE((SymbolTableEntry)it.getKey());
                    varDecl.setExpression((Expression)it.getValue());
                    return varDecl;
                };
                VariableStatement __VariableStatement = TranspilerBuilderBlocks._VariableStatement((VariableStatementKeyword)varStmtKeyword, (VariableDeclaration[])((VariableDeclaration[])Conversions.unwrapArray((Object)ListExtensions.map((List)simpleAssignments, (Functions.Function1)_function), VariableDeclaration.class)));
                toBeInserted.add(__VariableStatement);
            } else {
                VariableStatement __VariableStatement_1 = TranspilerBuilderBlocks._VariableStatement((VariableDeclaration[])((VariableDeclaration[])Conversions.unwrapArray((Object)helperVars, VariableDeclaration.class)));
                toBeInserted.add(__VariableStatement_1);
                Functions.Function1 _function_1 = it -> TranspilerBuilderBlocks._ExprStmnt((Expression)TranspilerBuilderBlocks._AssignmentExpr((Expression)this.__NSSafe_IdentRef((SymbolTableEntry)it.getKey()), (Expression)((Expression)it.getValue())));
                List _map = ListExtensions.map((List)simpleAssignments, (Functions.Function1)_function_1);
                Iterables.addAll((Collection)toBeInserted, (Iterable)_map);
            }
            body.getStatements().addAll(0, (Collection)toBeInserted);
            stmnt.setInitExpr(null);
            stmnt.getVarDeclsOrBindings().clear();
            EList _varDeclsOrBindings_1 = stmnt.getVarDeclsOrBindings();
            _varDeclsOrBindings_1.add((Object)iterVar);
        }
    }

    private List<VariableDeclaration> computeVariableDeclarations(List<VariableDeclarationOrBinding> varDeclsOrBindings) {
        ArrayList result = CollectionLiterals.newArrayList();
        ArrayList<VariableDeclarationOrBinding> _arrayList = new ArrayList<VariableDeclarationOrBinding>(varDeclsOrBindings);
        for (VariableDeclarationOrBinding vdeclOrBinding : _arrayList) {
            if (vdeclOrBinding instanceof VariableDeclaration) {
                result.add((VariableDeclaration)vdeclOrBinding);
                continue;
            }
            if (!(vdeclOrBinding instanceof VariableBinding)) continue;
            DestructNode rootNode = DestructNode.unify((VariableBinding)((VariableBinding)vdeclOrBinding));
            ArrayList helperVars = CollectionLiterals.newArrayList();
            ArrayList simpleAssignments = CollectionLiterals.newArrayList();
            this.traverse(helperVars, simpleAssignments, rootNode, ((VariableBinding)vdeclOrBinding).getExpression(), null);
            Functions.Function1 _function = it -> {
                VariableDeclaration varDecl = DestructuringTransformation.getVariableDeclarationFromSTE((SymbolTableEntry)it.getKey());
                varDecl.setExpression((Expression)it.getValue());
                return varDecl;
            };
            List _map = ListExtensions.map((List)simpleAssignments, (Functions.Function1)_function);
            Iterables.addAll((Collection)result, (Iterable)_map);
        }
        return result;
    }

    private void traverse(List<VariableDeclaration> helperVars, List<Pair<SymbolTableEntry, ? extends Expression>> simpleAssignments, DestructNode rootNode, Expression value, String fparName) {
        Object _elvis = null;
        VariableEnvironmentElement _scope = N4JSASTUtils.getScope((EObject)rootNode.getAstElement(), (boolean)false);
        _elvis = _scope != null ? _scope : this.getState().im;
        VariableEnvironmentElement scope = _elvis;
        BiFunction<Integer, Integer, Integer> _function = (i, j) -> i + j;
        Integer _merge = this.destructsPerScope.merge(scope, 1, _function);
        int n = _merge - 1;
        this.traverse(helperVars, simpleAssignments, rootNode.getNestedNodes(), value, fparName, Integer.toString(n));
    }

    private void traverse(List<VariableDeclaration> helperVars, List<Pair<SymbolTableEntry, ? extends Expression>> simpleAssignments, DestructNode[] nodes, Expression value, String fparName, String helperVarSuffix) {
        int len = nodes.length;
        Functions.Function1 _function = it -> it.isPositional();
        boolean isPositionalPattern = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)nodes)), (Functions.Function1)_function);
        boolean isRest = isPositionalPattern && !((List)Conversions.doWrapArray((Object)nodes)).isEmpty() && ((DestructNode)IterableExtensions.last((Iterable)((Iterable)Conversions.doWrapArray((Object)nodes)))).isRest();
        String currHelperVarName = "$destruct" + helperVarSuffix;
        VariableDeclaration currHelperVarDecl = TranspilerBuilderBlocks._VariableDeclaration((String)currHelperVarName);
        helperVars.add(currHelperVarDecl);
        SymbolTableEntry currHelperVarSTE = this.findSymbolTableEntryForElement((NamedElement)currHelperVarDecl, true);
        SymbolTableEntryInternal $sliceToArrayForDestructSTE = this.steFor_$sliceToArrayForDestruct();
        if (isRest) {
            ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._Snippet((String)"function(arr){return Array.isArray(arr) ? arr : Array.from(arr);}"), (Expression[])new Expression[]{value});
            Pair _mappedTo = Pair.of((Object)currHelperVarSTE, (Object)__CallExpr);
            simpleAssignments.add((Pair<SymbolTableEntry, ? extends Expression>)_mappedTo);
        } else {
            Expression _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)fparName);
            if (_isNullOrEmpty) {
                _xifexpression = value;
            } else {
                IdentifierRef_IM _xblockexpression = null;
                SymbolTableEntryInternal fparSTE = this.getSymbolTableEntryInternal(fparName, true);
                _xblockexpression = TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)fparSTE);
                _xifexpression = _xblockexpression;
            }
            Expression passValue = _xifexpression;
            if (isPositionalPattern) {
                ParameterizedCallExpression __CallExpr_1 = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)$sliceToArrayForDestructSTE), (Expression[])new Expression[]{TranspilerBuilderBlocks._Parenthesis((Expression)passValue), TranspilerBuilderBlocks._NumericLiteral((int)len)});
                Pair _mappedTo_1 = Pair.of((Object)currHelperVarSTE, (Object)__CallExpr_1);
                simpleAssignments.add((Pair<SymbolTableEntry, ? extends Expression>)_mappedTo_1);
            } else {
                ParenExpression __Parenthesis = TranspilerBuilderBlocks._Parenthesis((Expression)passValue);
                Pair _mappedTo_2 = Pair.of((Object)currHelperVarSTE, (Object)__Parenthesis);
                simpleAssignments.add((Pair<SymbolTableEntry, ? extends Expression>)_mappedTo_2);
            }
        }
        SymbolTableEntryOriginal sliceSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.arrayType((RuleEnvironment)this.getState().G), "slice", false, false, true);
        int nestedPatternsCounter = 0;
        int i = 0;
        while (i < len) {
            DestructNode currNode = nodes[i];
            IndexedAccessExpression _xifexpression_1 = null;
            if (isRest && i == len - 1) {
                _xifexpression_1 = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)currHelperVarSTE, (SymbolTableEntry[])new SymbolTableEntry[]{sliceSTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._NumericLiteral((int)i)});
            } else {
                IndexedAccessExpression _xifexpression_2 = null;
                _xifexpression_2 = isPositionalPattern ? TranspilerBuilderBlocks._IndexAccessExpr((SymbolTableEntry)currHelperVarSTE, (Expression)TranspilerBuilderBlocks._NumericLiteral((int)i)) : TranspilerBuilderBlocks._IndexAccessExpr((SymbolTableEntry)currHelperVarSTE, (Expression)TranspilerBuilderBlocks._StringLiteral((String)currNode.getPropName()));
                _xifexpression_1 = _xifexpression_2;
            }
            IndexedAccessExpression currValueRaw = _xifexpression_1;
            Object _xifexpression_3 = null;
            Expression _defaultExpr = currNode.getDefaultExpr();
            boolean _tripleNotEquals = _defaultExpr != null;
            _xifexpression_3 = _tripleNotEquals ? TranspilerBuilderBlocks._ConditionalExpr((Expression)TranspilerBuilderBlocks._EqualityExpr((Expression)((Expression)this.copy((EObject)currValueRaw)), (EqualityOperator)EqualityOperator.SAME, (Expression)this.undefinedRef()), (Expression)TranspilerBuilderBlocks._Parenthesis((Expression)currNode.getDefaultExpr()), (Expression)currValueRaw) : currValueRaw;
            IndexedAccessExpression currValue = _xifexpression_3;
            if (currNode.getVarRef() != null || currNode.getVarDecl() != null) {
                IdentifierRef _elvis = null;
                IdentifierRef _varRef = currNode.getVarRef();
                if (_varRef != null) {
                    _elvis = _varRef;
                } else {
                    VariableDeclaration _varDecl = currNode.getVarDecl();
                    _elvis = _varDecl;
                }
                IdentifierRef varSource = _elvis;
                SymbolTableEntry _switchResult = null;
                boolean _matched = false;
                if (varSource instanceof IdentifierRef_IM) {
                    _matched = true;
                    _switchResult = ((IdentifierRef_IM)varSource).getId_IM();
                }
                if (!_matched && varSource instanceof VariableDeclaration) {
                    _matched = true;
                    _switchResult = this.findSymbolTableEntryForElement((NamedElement)varSource, true);
                }
                SymbolTableEntry varSTE = _switchResult;
                Pair _mappedTo_3 = Pair.of((Object)varSTE, (Object)currValue);
                simpleAssignments.add((Pair<SymbolTableEntry, ? extends Expression>)_mappedTo_3);
            } else if (currNode.getNestedNodes() != null && !((List)Conversions.doWrapArray((Object)currNode.getNestedNodes())).isEmpty()) {
                this.traverse(helperVars, simpleAssignments, currNode.getNestedNodes(), (Expression)currValue, null, String.valueOf(helperVarSuffix) + "$" + Integer.valueOf(++nestedPatternsCounter));
            }
            ++i;
        }
    }

    private static final int getNestingDepth(ForStatement stmnt) {
        int d = 0;
        ForStatement obj = stmnt;
        while ((obj = obj.eContainer()) != null) {
            if (!(obj instanceof ForStatement)) continue;
            ++d;
        }
        return d;
    }

    public static EList<? super Statement> getContainingVariableEnvironmentContent(EObject astNode) {
        VariableEnvironmentElement vee = (VariableEnvironmentElement)EcoreUtil2.getContainerOfType((EObject)astNode.eContainer(), VariableEnvironmentElement.class);
        if (vee == null) {
            throw new IllegalArgumentException("given AST node does not have an outer variable environment");
        }
        EList _switchResult = null;
        boolean _matched = false;
        if (vee instanceof Script) {
            _matched = true;
            _switchResult = ((Script)vee).getScriptElements();
        }
        if (!_matched && vee instanceof FunctionOrFieldAccessor) {
            _matched = true;
            _switchResult = ((FunctionOrFieldAccessor)vee).getBody().getStatements();
        }
        if (!_matched && vee instanceof CatchBlock) {
            _matched = true;
            _switchResult = ((CatchBlock)vee).getBlock().getStatements();
        }
        if (!_matched && vee instanceof PropertyAssignment) {
            _matched = true;
            _switchResult = DestructuringTransformation.getContainingVariableEnvironmentContent((EObject)vee);
        }
        if (!_matched && vee instanceof WithStatement) {
            boolean _not;
            _matched = true;
            EList _xblockexpression = null;
            Statement _statement = ((WithStatement)vee).getStatement();
            boolean bl = _not = !(_statement instanceof Block);
            if (_not) {
                ((WithStatement)vee).setStatement((Statement)TranspilerBuilderBlocks._Block((Statement[])new Statement[]{((WithStatement)vee).getStatement()}));
            }
            Statement _statement_1 = ((WithStatement)vee).getStatement();
            _switchResult = _xblockexpression = ((Block)_statement_1).getStatements();
        }
        return _switchResult;
    }

    private static VariableDeclaration getVariableDeclarationFromSTE(SymbolTableEntry ste) {
        return (VariableDeclaration)IterableExtensions.head((Iterable)Iterables.filter((Iterable)ste.getElementsOfThisName(), VariableDeclaration.class));
    }
}

