/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.editor.contentassist;

import org.eclipse.xtext.ide.editor.contentassist.IPrefixMatcher;

public class CamelCasePrefixMatcher
extends IPrefixMatcher.IgnoreCase {
    public boolean isCandidateMatchingPrefix(String name, String prefix) {
        boolean result = super.isCandidateMatchingPrefix(name, prefix) || prefix.length() < name.length() && CamelCasePrefixMatcher.camelCaseMatch(name, prefix);
        return result;
    }

    private static boolean camelCaseMatch(String name, String prefix) {
        return CamelCasePrefixMatcher.camelCaseMatch(prefix.toCharArray(), name.toCharArray());
    }

    private static boolean camelCaseMatch(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return CamelCasePrefixMatcher.camelCaseMatch(pattern, 0, pattern.length, name, 0, name.length, false);
    }

    private static boolean camelCaseMatch(char[] pattern, int patternStart, int patternEnd, char[] name, int nameStart, int nameEnd, boolean samePartCount) {
        if (name == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        if (patternEnd < 0) {
            patternEnd = pattern.length;
        }
        if (nameEnd < 0) {
            nameEnd = name.length;
        }
        if (patternEnd <= patternStart) {
            return nameEnd <= nameStart;
        }
        if (nameEnd <= nameStart) {
            return false;
        }
        if (name[nameStart] != pattern[patternStart]) {
            return false;
        }
        int iPattern = patternStart;
        int iName = nameStart;
        block0: while (true) {
            char nameChar;
            ++iName;
            if (++iPattern == patternEnd) {
                if (!samePartCount || iName == nameEnd) {
                    return true;
                }
                while (true) {
                    if (iName == nameEnd) {
                        return true;
                    }
                    nameChar = name[iName];
                    if (!Character.isJavaIdentifierPart(nameChar) || Character.isUpperCase(nameChar)) {
                        return false;
                    }
                    ++iName;
                }
            }
            if (iName == nameEnd) {
                return false;
            }
            char patternChar = pattern[iPattern];
            if (patternChar == name[iName]) continue;
            if (Character.isJavaIdentifierPart(patternChar) && !Character.isUpperCase(patternChar) && !Character.isDigit(patternChar)) {
                return false;
            }
            while (true) {
                if (iName == nameEnd) {
                    return false;
                }
                nameChar = name[iName];
                if (Character.isJavaIdentifierPart(nameChar) && !Character.isUpperCase(nameChar)) {
                    ++iName;
                    continue;
                }
                if (Character.isDigit(nameChar)) {
                    if (patternChar == nameChar) continue block0;
                    ++iName;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(nameChar) || !Character.isUpperCase(nameChar) || iName <= 0 || !Character.isUpperCase(name[iName - 1])) break;
                if (patternChar == nameChar) continue block0;
                ++iName;
            }
            if (patternChar != nameChar) break;
        }
        return false;
    }
}

