/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.contentassist;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.n4js.ide.xtext.server.contentassist.XIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IIdeContentProposalAcceptor;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalProvider;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class XContentAssistService {
    @Inject
    private Provider<ContentAssistContextFactory> contextFactoryProvider;
    @Inject
    private ExecutorService executorService;
    @Inject
    private IdeContentProposalProvider proposalProvider;
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public CompletionList createCompletionList(Document document, XtextResource resource, TextDocumentPositionParams params, CancelIndicator cancelIndicator) {
        Position caretPosition;
        int caretOffset;
        XIdeContentProposalAcceptor acceptor;
        CompletionList result;
        block2: {
            result = new CompletionList();
            result.setIsIncomplete(false);
            acceptor = new XIdeContentProposalAcceptor(cancelIndicator);
            caretOffset = document.getOffSet(params.getPosition());
            caretPosition = params.getPosition();
            TextRegion position = new TextRegion(caretOffset, 0);
            try {
                this.createProposals(document.getContents(), position, caretOffset, resource, acceptor);
            }
            catch (Throwable t) {
                if (this.operationCanceledManager.isOperationCanceledException(t)) break block2;
                throw t;
            }
        }
        this.operationCanceledManager.checkCanceled(cancelIndicator);
        IterableExtensions.forEach(acceptor.getEntries(), (it, idx) -> {
            CompletionItem item = this.toCompletionItem((ContentAssistEntry)it, caretOffset, caretPosition, document);
            item.setSortText(Strings.padStart((String)Integer.toString(idx), (int)5, (char)'0'));
            result.getItems().add(item);
        });
        return result;
    }

    protected void createProposals(String document, TextRegion selection, int caretOffset, XtextResource resource, IIdeContentProposalAcceptor acceptor) {
        if (caretOffset > document.length()) {
            return;
        }
        ContentAssistContextFactory contextFactory = (ContentAssistContextFactory)this.contextFactoryProvider.get();
        contextFactory.setPool(this.executorService);
        ContentAssistContext[] contexts = contextFactory.create(document, (ITextRegion)selection, caretOffset, resource);
        this.proposalProvider.createProposals(Arrays.asList(contexts), acceptor);
    }

    protected CompletionItem toCompletionItem(ContentAssistEntry entry, int caretOffset, Position caretPosition, Document document) {
        CompletionItem result = new CompletionItem();
        String label = null;
        label = entry.getLabel() != null ? entry.getLabel() : entry.getProposal();
        result.setLabel(label);
        result.setDetail(entry.getDescription());
        result.setDocumentation(entry.getDocumentation());
        String prefix = null;
        prefix = entry.getPrefix() != null ? entry.getPrefix() : "";
        Position prefixPosition = document.getPosition(caretOffset - prefix.length());
        result.setTextEdit(new TextEdit(new Range(prefixPosition, caretPosition), entry.getProposal()));
        result.setKind(this.translateKind(entry));
        if (!entry.getTextReplacements().isEmpty()) {
            if (result.getAdditionalTextEdits() == null) {
                result.setAdditionalTextEdits(new ArrayList(entry.getTextReplacements().size()));
            }
            entry.getTextReplacements().forEach(it -> result.getAdditionalTextEdits().add(this.toTextEdit((ReplaceRegion)it, document)));
        }
        if (Objects.equal((Object)entry.getKind(), (Object)"SNIPPET")) {
            result.setInsertTextFormat(InsertTextFormat.Snippet);
        }
        return result;
    }

    protected CompletionItemKind translateKind(ContentAssistEntry entry) {
        CompletionItemKind result;
        block60: {
            block58: {
                result = null;
                if (entry.getKind() == null) break block58;
                switch (entry.getKind()) {
                    case "CLASS": {
                        result = CompletionItemKind.Class;
                        break;
                    }
                    case "COLOR": {
                        result = CompletionItemKind.Color;
                        break;
                    }
                    case "CONSTRUCTOR": {
                        result = CompletionItemKind.Constructor;
                        break;
                    }
                    case "ENUM": {
                        result = CompletionItemKind.Enum;
                        break;
                    }
                    case "FIELD": {
                        result = CompletionItemKind.Field;
                        break;
                    }
                    case "FILE": {
                        result = CompletionItemKind.File;
                        break;
                    }
                    case "FUNCTION": {
                        result = CompletionItemKind.Function;
                        break;
                    }
                    case "INTERFACE": {
                        result = CompletionItemKind.Interface;
                        break;
                    }
                    case "KEYWORD": {
                        result = CompletionItemKind.Keyword;
                        break;
                    }
                    case "METHOD": {
                        result = CompletionItemKind.Method;
                        break;
                    }
                    case "MODULE": {
                        result = CompletionItemKind.Module;
                        break;
                    }
                    case "PROPERTY": {
                        result = CompletionItemKind.Property;
                        break;
                    }
                    case "REFERENCE": {
                        result = CompletionItemKind.Reference;
                        break;
                    }
                    case "SNIPPET": {
                        result = CompletionItemKind.Snippet;
                        break;
                    }
                    case "TEXT": {
                        result = CompletionItemKind.Text;
                        break;
                    }
                    case "UNIT": {
                        result = CompletionItemKind.Unit;
                        break;
                    }
                    case "VALUE": {
                        result = CompletionItemKind.Value;
                        break;
                    }
                    case "VARIABLE": {
                        result = CompletionItemKind.Variable;
                        break;
                    }
                    default: {
                        result = CompletionItemKind.Value;
                        break;
                    }
                }
                break block60;
            }
            result = CompletionItemKind.Value;
        }
        return result;
    }

    protected TextEdit toTextEdit(ReplaceRegion region, Document doc) {
        Position start;
        if (region.getOffset() > doc.getContents().length()) {
            Position docEnd = doc.getPosition(doc.getContents().length());
            start = new Position(docEnd.getLine(), docEnd.getCharacter() + region.getLength());
        } else {
            start = doc.getPosition(region.getOffset());
        }
        Position end = region.getEndOffset() > doc.getContents().length() ? new Position(start.getLine(), start.getCharacter() + region.getLength()) : doc.getPosition(region.getEndOffset());
        return new TextEdit(new Range(start, end), region.getText());
    }
}

