/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.helper;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.utils.DependencyTraverser;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SourceContainerAwareDependencyProvider
implements DependencyTraverser.DependencyProvider<IN4JSProject> {
    private final boolean ignoreExternalPlainJsProjects;

    public SourceContainerAwareDependencyProvider(boolean ignoreExternalPlainJsProjects) {
        this.ignoreExternalPlainJsProjects = ignoreExternalPlainJsProjects;
    }

    public Collection<? extends IN4JSProject> getDependencies(IN4JSProject p) {
        if (this.ignoreExternalPlainJsProjects) {
            Functions.Function1 _function = dep -> {
                boolean _isIgnored = SourceContainerAwareDependencyProvider.isIgnored(dep);
                return !_isIgnored;
            };
            return ImmutableList.copyOf((Iterable)IterableExtensions.filter(p.getAllDirectDependencies(), (Functions.Function1)_function));
        }
        return p.getAllDirectDependencies();
    }

    private static boolean isIgnored(IN4JSProject project) {
        return project.isExternal() && (project.getProjectType() == ProjectType.VALIDATION || project.getProjectType() == ProjectType.PLAINJS);
    }
}

