/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods;

import com.google.inject.Inject;
import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.ui.organize.imports.BreakException;
import org.eclipse.n4js.ui.organize.imports.Interaction;
import org.eclipse.n4js.ui.organize.imports.UnsafeImortsOrganizer;
import org.eclipse.n4js.xpect.common.XpectCommentRemovalUtil;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilder;
import org.eclipse.n4js.xpect.ui.methods.contentassist.N4ContentAssistProcessorTestBuilderHelper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.expectation.StringDiffExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestModuleSetup;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.junit.Assert;

@XpectImport(value={ValidationTestModuleSetup.class})
public class OrganizeImportXpectMethod {
    private static final Logger logger;
    @Inject
    UnsafeImortsOrganizer imortsOrganizer;
    @Inject
    private N4ContentAssistProcessorTestBuilderHelper n4ContentAssistProcessorTestBuilderHelper;
    @Inject
    XtextDocumentProvider xdocProvider;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
        logger = Logger.getLogger(OrganizeImportXpectMethod.class);
    }

    @ParameterParser(syntax="('ambiguous' arg0=STRING)?")
    @Xpect
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void organizeImports(String ambiguous, @StringDiffExpectation(whitespaceSensitive=false, allowSingleSegmentDiff=false, allowSingleLineDiff=false) IStringDiffExpectation expectation, @ThisResource XtextResource resource) throws Exception {
        logger.info((Object)"organize imports ...");
        boolean bAmbiguityCheck = ambiguous != null && ambiguous.trim().length() > 0;
        Interaction iaMode = bAmbiguityCheck ? Interaction.breakBuild : Interaction.takeFirst;
        try {
            if (expectation == null) {
                throw new AssertionFailedError("The test is missing a diff: // XPECT organizeImports --> [old string replaced|new string expected] ");
            }
            String beforeApplication = resource.getParseResult().getRootNode().getText();
            N4ContentAssistProcessorTestBuilder fixture = this.n4ContentAssistProcessorTestBuilderHelper.createTestBuilderForResource(resource);
            IXtextDocument xtextDoc = fixture.getDocument(resource, beforeApplication);
            ResourceSet resSet = resource.getResourceSet();
            for (Resource currRes : new ArrayList(resSet.getResources())) {
                N4JSResource.postProcess((Resource)currRes);
            }
            Display.getDefault().syncExec(() -> this.imortsOrganizer.unsafeOrganizeDocument(xtextDoc, iaMode));
            if (bAmbiguityCheck) {
                Assert.assertEquals((String)"Expected ambiguous resolution to break the organize import command.", (Object)ambiguous, (Object)"");
            }
            String textAfterApplication = xtextDoc.get();
            String before = XpectCommentRemovalUtil.removeAllXpectComments((String)beforeApplication);
            String after = XpectCommentRemovalUtil.removeAllXpectComments((String)textAfterApplication);
            expectation.assertDiffEquals(before, after);
        }
        catch (Exception exc) {
            if (exc instanceof RuntimeException && exc.getCause() instanceof BreakException) {
                String breakMessage = exc.getCause().getMessage();
                Assert.assertEquals((Object)ambiguous, (Object)breakMessage);
            }
            throw exc;
        }
    }
}

