/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler;

import com.google.common.base.Joiner;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.utils.collections.Arrays2;

public abstract class TransformationDependency {
    public static final boolean isActiveIn(Transformation transformation, GeneratorOption[] activeOptions) {
        Optional ann = transformation.getClass().getAnnotation(Optional.class);
        if (ann != null) {
            GeneratorOption[] annOptions;
            GeneratorOption[] generatorOptionArray = annOptions = ann.value();
            int n = annOptions.length;
            int n2 = 0;
            while (n2 < n) {
                GeneratorOption annOption = generatorOptionArray[n2];
                if (GeneratorOption.isActiveIn((GeneratorOption)annOption, (GeneratorOption[])activeOptions)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public static final Transformation[] filterByTranspilerOptions(Transformation[] transformations, GeneratorOption[] options) {
        return (Transformation[])Stream.of(transformations).filter(t -> TransformationDependency.isActiveIn(t, options)).toArray(Transformation[]::new);
    }

    public static final String check(Class<? extends Transformation> curr, Annotation dep, Class<? extends Transformation>[] before, Class<? extends Transformation>[] after) {
        ArrayList<Class<? extends Transformation>> wrongTrafos = new ArrayList<Class<? extends Transformation>>();
        Class<? extends Transformation>[] classArray = TransformationDependency.getValue(dep);
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Transformation> reqOrExclTrafo = classArray[n2];
            if (dep.annotationType() == Requires.class) {
                if (!TransformationDependency.contains(before, reqOrExclTrafo) && !TransformationDependency.contains(after, reqOrExclTrafo)) {
                    wrongTrafos.add(reqOrExclTrafo);
                }
            } else if (dep.annotationType() == RequiresBefore.class) {
                if (!TransformationDependency.contains(before, reqOrExclTrafo)) {
                    wrongTrafos.add(reqOrExclTrafo);
                }
            } else if (dep.annotationType() == RequiresAfter.class) {
                if (!TransformationDependency.contains(after, reqOrExclTrafo)) {
                    wrongTrafos.add(reqOrExclTrafo);
                }
            } else if (dep.annotationType() == Excludes.class) {
                if (TransformationDependency.contains(before, reqOrExclTrafo) || TransformationDependency.contains(after, reqOrExclTrafo)) {
                    wrongTrafos.add(reqOrExclTrafo);
                }
            } else if (dep.annotationType() == ExcludesBefore.class) {
                if (TransformationDependency.contains(before, reqOrExclTrafo)) {
                    wrongTrafos.add(reqOrExclTrafo);
                }
            } else if (dep.annotationType() == ExcludesAfter.class && TransformationDependency.contains(after, reqOrExclTrafo)) {
                wrongTrafos.add(reqOrExclTrafo);
            }
            ++n2;
        }
        if (!wrongTrafos.isEmpty()) {
            String dependencyString = dep.annotationType().getSimpleName();
            Iterator wrongTrafoNames = wrongTrafos.stream().map(t -> t.getSimpleName()).iterator();
            return String.valueOf(curr.getSimpleName()) + " @" + dependencyString + ": " + Joiner.on((String)", ").join(wrongTrafoNames);
        }
        return null;
    }

    public static final List<String> check(Class<? extends Transformation>[] transformations) {
        ArrayList<String> errMsgs = new ArrayList<String>();
        int idx = 0;
        while (idx < transformations.length) {
            Class<? extends Transformation> currT = transformations[idx];
            Class<? extends Transformation>[] before = Arrays.copyOf(transformations, idx);
            Class<? extends Transformation>[] after = Arrays.copyOfRange(transformations, idx + 1, transformations.length);
            Annotation[] annotationArray = currT.getAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation ann = annotationArray[n2];
                String errMsg = TransformationDependency.check(currT, ann, before, after);
                if (errMsg != null) {
                    errMsgs.add(errMsg);
                }
                ++n2;
            }
            ++idx;
        }
        return errMsgs;
    }

    public static final void assertDependencies(Transformation[] transformations) {
        Class[] sequence = Arrays2.transform((Object[])transformations, t -> t.getClass()).toArray(new Class[0]);
        List<String> errMsgs = TransformationDependency.check(sequence);
        if (!errMsgs.isEmpty()) {
            throw new AssertionError((Object)("one or more dependencies between transformations are violated:\n" + Joiner.on((String)"\n").join(errMsgs)));
        }
    }

    private static final Class<? extends Transformation>[] getValue(Annotation ann) {
        if (ann instanceof Requires) {
            return ((Requires)ann).value();
        }
        if (ann instanceof RequiresBefore) {
            return ((RequiresBefore)ann).value();
        }
        if (ann instanceof RequiresAfter) {
            return ((RequiresAfter)ann).value();
        }
        if (ann instanceof Excludes) {
            return ((Excludes)ann).value();
        }
        if (ann instanceof ExcludesBefore) {
            return ((ExcludesBefore)ann).value();
        }
        if (ann instanceof ExcludesAfter) {
            return ((ExcludesAfter)ann).value();
        }
        if (ann instanceof Optional) {
            return new Class[0];
        }
        throw new IllegalArgumentException("unknown transformation dependency annotation: " + ann);
    }

    private static final <T> boolean contains(T[] array, T value) {
        return org.eclipse.xtext.util.Arrays.contains((Object[])array, value);
    }

    private TransformationDependency() {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Excludes {
        public Class<? extends Transformation>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExcludesAfter {
        public Class<? extends Transformation>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExcludesBefore {
        public Class<? extends Transformation>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Optional {
        public GeneratorOption[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Requires {
        public Class<? extends Transformation>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RequiresAfter {
        public Class<? extends Transformation>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RequiresBefore {
        public Class<? extends Transformation>[] value();
    }
}

