/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;
import org.eclipse.n4js.utils.io.OutputRedirection;

public class OutputStreamPrinterThread
extends Thread
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(OutputStreamPrinterThread.class);
    private final InputStream is;
    private final OutputStream os;
    private final ByteArrayOutputStream baos;
    private final OutputRedirection redirect;

    OutputStreamPrinterThread(InputStream is, OutputStream os, OutputRedirection redirect) {
        this.is = (InputStream)Preconditions.checkNotNull((Object)is, (Object)"is");
        this.os = (OutputStream)Preconditions.checkNotNull((Object)os, (Object)"os");
        this.setName(this.getClass().getSimpleName());
        this.baos = new ByteArrayOutputStream();
        this.redirect = redirect;
    }

    @Override
    public void run() {
        try {
            int numberOfReadBytes;
            byte[] buffer = new byte[1024];
            BufferedInputStream bis = new BufferedInputStream(this.is);
            while ((numberOfReadBytes = bis.read(buffer)) != -1) {
                byte[] clearedBuffer = new byte[numberOfReadBytes];
                System.arraycopy(buffer, 0, clearedBuffer, 0, numberOfReadBytes);
                this.baos.write(clearedBuffer);
                if (this.redirect != OutputRedirection.REDIRECT) continue;
                this.os.write(clearedBuffer);
            }
        }
        catch (Exception e) {
            String message = "Error reading output of running process.";
            LOGGER.error((Object)"Error reading output of running process.", (Throwable)e);
            throw new RuntimeException("Error reading output of running process.", e);
        }
    }

    @Override
    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                LOGGER.error((Object)"Error while closing input stream for printer thread.", (Throwable)e);
                try {
                    this.is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String toString() {
        try {
            return this.baos.toString(Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return Throwables.getStackTraceAsString((Throwable)e);
        }
    }

    public static enum OutputStreamType {
        STD_OUT,
        STD_ERR;

    }
}

