/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class OpenDocumentTracker {
    private static final Logger LOG = Logger.getLogger(OpenDocumentTracker.class);
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    private Map<URI, IXtextDocument> resourceUri2document = Maps.newHashMap();
    private Map<IWorkbenchPartReference, URI> part2resourceURI = Maps.newHashMap();
    private IPageListener pageListener;
    private IPartListener2 partListener;

    @Inject(optional=true)
    protected void initialize(IWorkbench workbench) {
        Assert.isNotNull((Object)Display.getCurrent());
        this.partListener = new PartListener();
        this.pageListener = new PageListener();
        IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            window.addPageListener(this.pageListener);
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                page.addPartListener(this.partListener);
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorRef = iEditorReferenceArray[n6];
                    Pair<URI, IXtextDocument> entry = this.getEntry((IWorkbenchPartReference)editorRef);
                    if (entry != null) {
                        this.resourceUri2document.put((URI)entry.getFirst(), (IXtextDocument)entry.getSecond());
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected Pair<URI, IXtextDocument> getEntry(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof XtextEditor) {
            XtextEditor xtextEditor = (XtextEditor)part;
            URI resourceURI = this.getResourceURI(xtextEditor);
            IXtextDocument document = xtextEditor.getDocument();
            if (resourceURI != null && document != null) {
                return Tuples.create((Object)resourceURI, (Object)document);
            }
        }
        return null;
    }

    protected URI getResourceURI(XtextEditor editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IStorageEditorInput) {
            try {
                return this.storage2UriMapper.getUri(((IStorageEditorInput)editorInput).getStorage());
            }
            catch (CoreException e) {
                LOG.error((Object)"Error getting URI for storage", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IXtextDocument getOpenDocument(URI resourceURI) {
        Map<URI, IXtextDocument> map = this.resourceUri2document;
        synchronized (map) {
            return this.resourceUri2document.get(resourceURI);
        }
    }

    protected class PageListener
    implements IPageListener {
        protected PageListener() {
        }

        public void pageOpened(IWorkbenchPage page) {
            page.addPartListener(OpenDocumentTracker.this.partListener);
        }

        public void pageClosed(IWorkbenchPage page) {
            page.removePartListener(OpenDocumentTracker.this.partListener);
        }

        public void pageActivated(IWorkbenchPage page) {
        }
    }

    protected class PartListener
    implements IPartListener2 {
        protected PartListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partOpened(IWorkbenchPartReference partRef) {
            Pair<URI, IXtextDocument> entry = OpenDocumentTracker.this.getEntry(partRef);
            if (entry != null) {
                Map map = OpenDocumentTracker.this.resourceUri2document;
                synchronized (map) {
                    OpenDocumentTracker.this.resourceUri2document.put((URI)entry.getFirst(), (IXtextDocument)entry.getSecond());
                    OpenDocumentTracker.this.part2resourceURI.put(partRef, (URI)entry.getFirst());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partInputChanged(IWorkbenchPartReference partRef) {
            Pair<URI, IXtextDocument> entry = OpenDocumentTracker.this.getEntry(partRef);
            if (entry != null) {
                Map map = OpenDocumentTracker.this.resourceUri2document;
                synchronized (map) {
                    URI oldURI = (URI)OpenDocumentTracker.this.part2resourceURI.remove(partRef);
                    OpenDocumentTracker.this.resourceUri2document.remove(oldURI);
                    OpenDocumentTracker.this.resourceUri2document.put((URI)entry.getFirst(), (IXtextDocument)entry.getSecond());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void partClosed(IWorkbenchPartReference partRef) {
            Pair<URI, IXtextDocument> entry = OpenDocumentTracker.this.getEntry(partRef);
            if (entry != null) {
                Map map = OpenDocumentTracker.this.resourceUri2document;
                synchronized (map) {
                    OpenDocumentTracker.this.part2resourceURI.remove(partRef);
                    OpenDocumentTracker.this.resourceUri2document.remove(entry.getFirst());
                }
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    }
}

