/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server.codeActions;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.n4js.ide.server.codeActions.CodeActionAcceptor;
import org.eclipse.n4js.ide.server.codeActions.N4JSQuickfixProvider;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.service.OperationCanceledManager;

public class N4JSCodeActionService
implements ICodeActionService2 {
    @Inject
    N4JSQuickfixProvider quickfixProvider;
    @Inject
    OperationCanceledManager cancelManager;

    public List<Either<Command, CodeAction>> getCodeActions(ICodeActionService2.Options options) {
        CodeActionAcceptor acceptor = new CodeActionAcceptor();
        List diagnostics = null;
        if (options.getCodeActionParams() != null && options.getCodeActionParams().getContext() != null) {
            diagnostics = options.getCodeActionParams().getContext().getDiagnostics();
        }
        if (diagnostics == null) {
            diagnostics = Collections.emptyList();
        }
        for (Diagnostic diag : diagnostics) {
            this.cancelManager.checkCanceled(options.getCancelIndicator());
            this.quickfixProvider.addQuickfix(diag.getCode(), options, acceptor);
        }
        this.cancelManager.checkCanceled(options.getCancelIndicator());
        return acceptor.getList();
    }
}

