/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.xpect.ui.XpectRunConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class LaunchXpectShortcut
implements ILaunchShortcut {
    public static final String LAUNCHCONFIGURATIONTYPE_XPECT_ID = "org.eclipse.n4js.xpect.ui.LaunchConfigurationType.XPECT";

    protected String getLaunchConfigTypeID() {
        return LAUNCHCONFIGURATIONTYPE_XPECT_ID;
    }

    private static void showDialogNotImplemented(String what) {
        MessageDialog.openWarning(null, (String)"Warning", (String)("Launching of type " + what + " is not implemeneted yet!"));
    }

    public void launch(ISelection selection, String mode) {
        try {
            Object selectObj = ((IStructuredSelection)selection).getFirstElement();
            if (selectObj instanceof IFile) {
                this.launchFile((IFile)selectObj, mode);
            } else {
                LaunchXpectShortcut.showDialogNotImplemented(selection.getClass().getName());
            }
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(e.getLocalizedMessage()) + "\n");
        }
    }

    public void launch(IEditorPart editor, String mode) {
        try {
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFile selectObj = ((IFileEditorInput)editorInput).getFile();
                this.launchFile(selectObj, mode);
            } else {
                LaunchXpectShortcut.showDialogNotImplemented(editor.getClass().getName());
            }
        }
        catch (CoreException e) {
            System.out.println(String.valueOf(e.getLocalizedMessage()) + "\n");
        }
    }

    public static String computeLaunchConfigNameFrom(IFile originalFileToRun, ILaunchConfigurationType type) {
        String configname = originalFileToRun.getFullPath().toString().replace('/', '-');
        if (configname.startsWith("-")) {
            configname = configname.substring(1);
        }
        configname = String.valueOf(configname) + " (" + type.getName() + ")";
        return configname;
    }

    protected void launchFile(IFile fileSelectedToRun, String mode) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(this.getLaunchConfigTypeID());
        String testFileLocation = fileSelectedToRun.getRawLocationURI().toString();
        String configName = LaunchXpectShortcut.computeLaunchConfigNameFrom(fileSelectedToRun, type);
        XpectRunConfiguration runConfig = XpectRunConfiguration.createToRunXtFile(configName, testFileLocation);
        runConfig.setConfigurationType(type);
        runConfig.setWorkingDirectory(fileSelectedToRun.getRawLocation().toFile());
        DebugUITools.launch((ILaunchConfiguration)runConfig.toLaunchConfiguration(), (String)mode);
    }
}

