/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.naming;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.utils.ResourceType;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class ModuleNameComputer {
    @Inject
    @Extension
    private IN4JSCore core;

    public QualifiedName getQualifiedModuleName(Resource resource) {
        return this.getQualifiedModuleName(resource.getURI());
    }

    public QualifiedName getQualifiedModuleName(IResourceDescription resourceDesc) {
        return this.getQualifiedModuleName(resourceDesc.getURI());
    }

    public QualifiedName getQualifiedModuleName(URI uri) {
        Optional<? extends IN4JSSourceContainer> maybeSourceContainer = this.core.findN4JSSourceContainer(uri);
        boolean _isPresent = maybeSourceContainer.isPresent();
        if (_isPresent) {
            IN4JSSourceContainer sourceContainer = (IN4JSSourceContainer)maybeSourceContainer.get();
            URI location = ((SafeURI)sourceContainer.getLocation().withTrailingPathDelimiter()).toURI();
            boolean _uriStartsWith = this.uriStartsWith(uri, location);
            if (_uriStartsWith) {
                URI relativeURI = uri.deresolve(location);
                relativeURI = ResourceType.xtHidesOtherExtension(uri) || Objects.equal((Object)"xt", (Object)uri.fileExtension().toLowerCase()) ? relativeURI.trimFileExtension().trimFileExtension() : relativeURI.trimFileExtension();
                return QualifiedName.create((String[])relativeURI.segments());
            }
        } else if (uri.segmentCount() == 1 && uri.fileExtension() != null && (ResourceType.xtHidesOtherExtension(uri) || Objects.equal((Object)"xt", (Object)uri.fileExtension().toLowerCase()))) {
            return QualifiedName.create((String[])uri.trimFileExtension().trimFileExtension().segments());
        }
        return this.createDefaultQualifiedName(uri);
    }

    private QualifiedName createDefaultQualifiedName(URI uri) {
        List segmentList = uri.trimFileExtension().segmentsList();
        int srcFolder = Math.max(segmentList.indexOf("src"), segmentList.indexOf("src-test"));
        if (srcFolder != -1) {
            segmentList = segmentList.subList(srcFolder + 1, segmentList.size());
        }
        return QualifiedName.create((List)segmentList);
    }

    private boolean uriStartsWith(URI resourceLocation, URI containerLocation) {
        boolean _lessThan;
        Preconditions.checkArgument((boolean)containerLocation.hasTrailingPathSeparator(), (String)"Must have trailing separator: %s", (Object)containerLocation);
        int _segmentCount = containerLocation.segmentCount();
        int maxSegments = _segmentCount - 1;
        int _segmentCount_1 = resourceLocation.segmentCount();
        boolean bl = _lessThan = _segmentCount_1 < maxSegments;
        if (_lessThan) {
            return false;
        }
        int i = 0;
        while (i < maxSegments) {
            String _segment_1;
            boolean _notEquals;
            String _segment = resourceLocation.segment(i);
            boolean bl2 = _notEquals = !Objects.equal((Object)_segment, (Object)(_segment_1 = containerLocation.segment(i)));
            if (_notEquals) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

