/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.lsp;

import com.google.common.util.concurrent.Futures;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.cli.lsp.PatchedLauncherBuilder;
import org.eclipse.n4js.ide.xtext.server.ProjectStatePersisterConfig;
import org.eclipse.n4js.ide.xtext.server.XLanguageServerImpl;

public class LspServer {
    private final N4jscOptions options;

    public static void start(N4jscOptions options) throws Exception {
        LspServer server = new LspServer(options);
        server.start();
    }

    private LspServer(N4jscOptions options) {
        this.options = options;
    }

    public void start() throws Exception {
        N4jscConsole.println("Start LSP server");
        ExecutorService threadPool = Executors.newCachedThreadPool();
        try {
            while (true) {
                this.setPersistionOptions();
                XLanguageServerImpl languageServer = N4jscFactory.getLanguageServer();
                this.setupAndRun(threadPool, languageServer);
                N4jscFactory.resetInjector();
            }
        }
        catch (Throwable throwable) {
            N4jscConsole.println("LSP server terminated.");
            throw throwable;
        }
    }

    private void setPersistionOptions() {
        Injector injector = N4jscFactory.getOrCreateInjector();
        ProjectStatePersisterConfig persisterConfig = (ProjectStatePersisterConfig)injector.getInstance(ProjectStatePersisterConfig.class);
        persisterConfig.setDeleteState(this.options.isClean());
        persisterConfig.setWriteToDisk(!this.options.isNoPersist());
    }

    private void setupAndRun(ExecutorService threadPool, XLanguageServerImpl languageServer) throws InterruptedException, ExecutionException, IOException {
        Launcher.Builder lsBuilder = new PatchedLauncherBuilder().setLocalService(languageServer).setRemoteInterface(LanguageClient.class).setExecutorService(threadPool);
        if (this.options.isStdio()) {
            N4jscConsole.setSuppress(true);
            this.setupAndRunWithSystemIO(languageServer, (Launcher.Builder<LanguageClient>)lsBuilder);
        } else {
            this.setupAndRunWithSocket(languageServer, (Launcher.Builder<LanguageClient>)lsBuilder);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupAndRunWithSocket(XLanguageServerImpl languageServer, Launcher.Builder<LanguageClient> lsBuilder) throws InterruptedException, ExecutionException, IOException {
        InetSocketAddress address = new InetSocketAddress("localhost", this.options.getPort());
        Throwable throwable = null;
        Object var5_6 = null;
        try (AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(address);){
            N4jscConsole.println("Listening for LSP clients on port " + this.options.getPort() + "...");
            Throwable throwable2 = null;
            Object var8_11 = null;
            try {
                AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
                try {
                    block25: {
                        InputStream in = Channels.newInputStream(socketChannel);
                        try {
                            try (OutputStream out = Channels.newOutputStream(socketChannel);){
                                N4jscConsole.println("Connected to LSP client");
                                this.run(languageServer, lsBuilder, in, out);
                            }
                            if (in == null) break block25;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (in == null) throw throwable2;
                            in.close();
                            throw throwable2;
                        }
                        in.close();
                    }
                    if (socketChannel == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    if (socketChannel == null) throw throwable2;
                    socketChannel.close();
                    throw throwable2;
                }
                socketChannel.close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                    throw throwable2;
                }
                if (throwable2 == throwable5) throw throwable2;
                throwable2.addSuppressed(throwable5);
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
                throw throwable;
            }
            if (throwable == throwable6) throw throwable;
            throwable.addSuppressed(throwable6);
            throw throwable;
        }
    }

    private void setupAndRunWithSystemIO(XLanguageServerImpl languageServer, Launcher.Builder<LanguageClient> lsBuilder) {
        this.run(languageServer, lsBuilder, System.in, System.out);
    }

    private void run(XLanguageServerImpl languageServer, Launcher.Builder<LanguageClient> lsBuilder, InputStream in, OutputStream out) {
        Launcher launcher = lsBuilder.setInput(in).setOutput(out).create();
        languageServer.connect((LanguageClient)launcher.getRemoteProxy());
        Future future = launcher.startListening();
        N4jscConsole.println("LSP Server connected");
        Futures.getUnchecked((Future)future);
        N4jscConsole.println("Shutdown connection to LSP client");
        languageServer.getRequestManager().shutdown();
    }
}

