/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.scoping;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.xtext.common.types.access.AbstractTypeProviderFactory;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.IWorkingCopyOwnerProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeProvider;
import org.eclipse.xtext.resource.XtextResourceSet;

public class ClasspathOrJdtBasedTypeScopeProviderFactory
extends AbstractTypeProviderFactory {
    @Inject
    private ClassLoader classLoader;
    @Inject
    private IJavaProjectProvider javaProjectProvider;
    @Inject
    private IWorkingCopyOwnerProvider wcProvider;

    protected ClasspathTypeProvider createClasspathTypeProvider(ResourceSet resourceSet) {
        return new ClasspathTypeProvider(this.getClassLoader(resourceSet), resourceSet, null);
    }

    protected IJdtTypeProvider createJdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        if (javaProject == null) {
            throw new IllegalStateException();
        }
        Object owner = this.wcProvider == null ? DefaultWorkingCopyOwner.PRIMARY : this.wcProvider.getWorkingCopyOwner(javaProject, resourceSet);
        return new JdtTypeProvider(javaProject, resourceSet, this.getIndexedJvmTypeAccess(), (WorkingCopyOwner)owner);
    }

    public IJvmTypeProvider createTypeProvider(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet may not be null.");
        }
        IJavaProject javaProject = this.javaProjectProvider.getJavaProject(resourceSet);
        if (javaProject != null) {
            return this.createJdtTypeProvider(javaProject, resourceSet);
        }
        return this.createClasspathTypeProvider(resourceSet);
    }

    public ClassLoader getClassLoader(ResourceSet resourceSet) {
        XtextResourceSet xtextResourceSet;
        Object ctx;
        if (resourceSet instanceof XtextResourceSet && (ctx = (xtextResourceSet = (XtextResourceSet)resourceSet).getClasspathURIContext()) != null) {
            if (ctx instanceof Class) {
                return ((Class)ctx).getClassLoader();
            }
            if (!(ctx instanceof ClassLoader)) {
                return ctx.getClass().getClassLoader();
            }
            return (ClassLoader)ctx;
        }
        return this.classLoader;
    }
}

